package com.autonavi.amapauto.ar.camera.model;

import androidx.annotation.Keep;
import java.util.Arrays;

@Keep
/* loaded from: classes.dex */
public class ArSensorInfo {
    public boolean gyroscopeValid = false;
    public boolean geoMagneticValid = false;
    public boolean accValid = false;
    public float[] accValues = new float[3];
    public float[] gyroscopeValues = new float[3];
    public float[] geoMagneticValues = new float[3];
    public float[] grivityData = new float[3];
    public float[] rotationMatrix = new float[16];
    public float[] remappedRotationMatrix = new float[16];
    public float[] orientations = new float[4];

    public String toString() {
        return "ArSensorInfo{ gyroscopeValid=" + this.gyroscopeValid + ", geoMagneticValid=" + this.geoMagneticValid + ", accValid=" + this.accValid + ", accValues=" + Arrays.toString(this.accValues) + ", gyroscopeValues=" + Arrays.toString(this.gyroscopeValues) + ", geoMagneticValues=" + Arrays.toString(this.geoMagneticValues) + ", grivityData=" + Arrays.toString(this.grivityData) + ", rotationMatrix=" + Arrays.toString(this.rotationMatrix) + ", remappedRotationMatrix=" + Arrays.toString(this.remappedRotationMatrix) + ", orientations=" + Arrays.toString(this.orientations) + '}';
    }
}
