package com.autonavi.amapauto.ar.camera.model;

import androidx.annotation.Keep;
import java.util.ArrayList;
import java.util.Iterator;

@Keep
/* loaded from: classes.dex */
public class ImageInfo {
    public int format = 0;
    public int width = 0;
    public int height = 0;
    public long timestamp = 0;
    public ArrayList<ImageChannel> data = new ArrayList<>(3);

    public void destroy() {
        Iterator<ImageChannel> it = this.data.iterator();
        while (it.hasNext()) {
            it.next().data = null;
        }
        this.data = null;
    }

    public String toString() {
        return "ImageInfo{format=" + this.format + ", width=" + this.width + ", height=" + this.height + ", data=" + this.data + ", timestamp=" + this.timestamp + '}';
    }
}
