package com.autonavi.amapauto.business.deviceadapter.dynamicfunction;

import android.content.Context;
import dalvik.system.DexClassLoader;
import defpackage.aa0;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

/* loaded from: classes.dex */
public class DynamicFuncImplProxy implements IVehicleDynamicFunc, IVoiceDynamicFunc, ICommonDynamicFunc {
    public static final String FUNC_IMPL_CLASS = "com.autonavi.amapauto.business.deviceadapter.dynamicfunction.funcimpl.DynamicFuncImpl";
    public static final String TAG = "DynamicFuncImplProxy";
    public final Class<?> mDynamicFuncClass;
    public final Object mDynamicFuncObj;

    public DynamicFuncImplProxy(Class<?> cls, Object obj) {
        this.mDynamicFuncClass = cls;
        this.mDynamicFuncObj = obj;
    }

    public static DynamicFuncImplProxy build(Context context, String str) {
        aa0.a(TAG, "build DynamicFuncImpl from {?}", str);
        if (context.getFilesDir() == null) {
            DynamicFuncManager.getInstance().collectionResult(1, "getFilesDir is null", "");
            return null;
        }
        try {
            Class loadClass = new DexClassLoader(str, context.getFilesDir().getAbsolutePath(), null, context.getClassLoader()).loadClass(FUNC_IMPL_CLASS);
            try {
                return new DynamicFuncImplProxy(loadClass, loadClass.getDeclaredConstructor(Context.class).newInstance(context));
            } catch (Exception e) {
                aa0.a(TAG, "newInstance DynamicFuncImplProxy exception:", e, new Object[0]);
                DynamicFuncManager.getInstance().collectionResult(1, "newInstance exception", e.getMessage());
                return null;
            }
        } catch (ClassNotFoundException e2) {
            aa0.a(TAG, "loadClass DynamicFuncImplProxy exception", e2, new Object[0]);
            DynamicFuncManager.getInstance().collectionResult(1, "loadClass exception", e2.getMessage());
            return null;
        }
    }

    private Method getMethod(String str, Class<?>... clsArr) throws NoSuchMethodException {
        try {
            return this.mDynamicFuncClass.getMethod(str, clsArr);
        } catch (NoSuchMethodException e) {
            String str2 = "getMethod " + str + " exception";
            aa0.a(TAG, str2, e, new Object[0]);
            DynamicFuncManager.getInstance().collectionResult(3, str2, e.getMessage());
            throw e;
        }
    }

    private Object invoke(Method method, Object... objArr) throws InvocationTargetException, IllegalAccessException {
        method.setAccessible(true);
        try {
            Object invoke = method.invoke(this.mDynamicFuncObj, objArr);
            DynamicFuncManager.getInstance().collectionResult(2, "invoke " + method.getName() + " success", "");
            return invoke;
        } catch (Exception e) {
            String str = "invoke " + method.getName() + " exception";
            aa0.a(TAG, str, e, new Object[0]);
            DynamicFuncManager.getInstance().collectionResult(3, str, e.getMessage());
            throw e;
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.IVoiceDynamicFunc
    public void abandonFocus() {
        try {
            invoke(getMethod("abandonFocus", new Class[0]), new Object[0]);
        } catch (Exception unused) {
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.ICommonDynamicFunc
    public boolean cleanup() {
        try {
            return ((Boolean) invoke(getMethod("cleanup", new Class[0]), new Object[0])).booleanValue();
        } catch (Exception unused) {
            return false;
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.IVoiceDynamicFunc
    public int getAudioStreamType() {
        try {
            return ((Integer) invoke(getMethod("getAudioStreamType", new Class[0]), new Object[0])).intValue();
        } catch (Exception unused) {
            return -1;
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.IVehicleDynamicFunc
    public int getHeadLampsOn() {
        try {
            return ((Integer) invoke(getMethod("getHeadLampsOn", new Class[0]), new Object[0])).intValue();
        } catch (Exception unused) {
            return -1;
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.IVoiceDynamicFunc
    public int getSystemMaxVolume() {
        try {
            return ((Integer) invoke(getMethod("getSystemMaxVolume", new Class[0]), new Object[0])).intValue();
        } catch (Exception unused) {
            return -1;
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.IVoiceDynamicFunc
    public int getSystemVolume() {
        try {
            return ((Integer) invoke(getMethod("getSystemVolume", new Class[0]), new Object[0])).intValue();
        } catch (Exception unused) {
            return -1;
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.ICommonDynamicFunc
    public List<String> getUsbUpdataPath() {
        try {
            return (List) invoke(getMethod("getUsbUpdataPath", new Class[0]), new Object[0]);
        } catch (Exception unused) {
            return null;
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.IVoiceDynamicFunc
    public int requestFocus(int i, int i2) {
        try {
            return ((Integer) invoke(getMethod("requestFocus", Integer.TYPE, Integer.TYPE), Integer.valueOf(i), Integer.valueOf(i2))).intValue();
        } catch (RuntimeException | Exception unused) {
            return -1;
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.ICommonDynamicFunc
    public void setAutoProxy(IAutoProxy iAutoProxy) {
        try {
            invoke(getMethod("setAutoProxy", IAutoProxy.class), iAutoProxy);
        } catch (RuntimeException e) {
            aa0.a(TAG, "setAutoProxy exception", e, new Object[0]);
        } catch (Exception e2) {
            aa0.a(TAG, "setAutoProxy exception", e2, new Object[0]);
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.IVoiceDynamicFunc
    public void setSystemVolume(int i, int i2) {
        try {
            invoke(getMethod("setSystemVolume", Integer.TYPE, Integer.TYPE), Integer.valueOf(i), Integer.valueOf(i2));
        } catch (RuntimeException e) {
            aa0.a(TAG, "setSystemVolume exception", e, new Object[0]);
        } catch (Exception e2) {
            aa0.a(TAG, "setSystemVolume exception", e2, new Object[0]);
        }
    }

    @Override // com.autonavi.amapauto.business.deviceadapter.dynamicfunction.ICommonDynamicFunc
    public boolean startup() {
        try {
            return ((Boolean) invoke(getMethod("startup", new Class[0]), new Object[0])).booleanValue();
        } catch (Exception unused) {
            return false;
        }
    }
}
