package com.autonavi.amapauto.business.deviceadapter.dynamicfunction;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.autonavi.amapauto.jni.config.AndroidAdapterConfiger;
import defpackage.aa0;
import defpackage.da0;
import defpackage.ee;
import defpackage.ei;
import defpackage.fi;
import defpackage.gp;
import defpackage.hi;
import defpackage.oj;
import defpackage.sh;
import defpackage.wh;
import defpackage.y90;
import defpackage.yh;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

/* loaded from: classes.dex */
public class DynamicFuncManager {
    public static final String CLOUD_FUNC_REPOSITORY_NAME = "cc_AdapterFuncRepository.dat";
    public static final String FUNC_REPOSITORY_NAME = "AdapterFuncRepository.dat";
    public static final String INNER_ADAPTER_DIR = "/AutoDeviceAdapter/";
    public static final String PACKAGE_INFO_NAME = "packageInfo.txt";
    public static final String TAG = "DynamicFuncManager";
    public String mExternalAdapterDir;
    public DynamicFuncImplProxy mImplProxy;
    public String mPackageVersion;
    public String mInternalAdapterDir = "";
    public final int[] MODULE_TYPE_ARRAY = {0, 1, 2, 3, 4, 5, 6, 7};

    /* loaded from: classes.dex */
    public static class a {
        public static final DynamicFuncManager a = new DynamicFuncManager();
    }

    private void clearDexFiles() {
        aa0.a(TAG, "clearDexFiles", new Object[0]);
        File file = new File(this.mInternalAdapterDir);
        if (file.listFiles() == null) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (file2.getName().endsWith(".jar")) {
                aa0.a(TAG, "delete: {?} {?}", file2.getName(), Boolean.valueOf(file2.delete()));
            }
        }
    }

    public static DynamicFuncManager getInstance() {
        return a.a;
    }

    private boolean isNeedUpdateDex() {
        File file = new File(this.mExternalAdapterDir + CLOUD_FUNC_REPOSITORY_NAME);
        if (!file.exists()) {
            file = new File(this.mExternalAdapterDir + FUNC_REPOSITORY_NAME);
            if (!file.exists()) {
                aa0.a(TAG, "checkDexUpdate, repositoryFile not exists", new Object[0]);
                return false;
            }
        }
        long a2 = sh.c().a("dynamicFuncRepositorySize", 0L);
        long length = file.length();
        if (a2 != length) {
            aa0.a(TAG, "checkDexUpdate, preSize={?}, crnSize={?}", Long.valueOf(a2), Long.valueOf(length));
            return true;
        }
        String a3 = yh.p().b().a(191, "");
        if (!TextUtils.isEmpty(a3)) {
            if (!new File(this.mInternalAdapterDir + a3).exists()) {
                aa0.a(TAG, "checkDexUpdate, dexFileName{?} lost", a3);
                return true;
            }
        }
        aa0.a(TAG, "checkDexUpdate, isNeedUpdateDex is false", new Object[0]);
        return false;
    }

    private void readPackageVersion() {
        File file = new File(this.mInternalAdapterDir + PACKAGE_INFO_NAME);
        if (!file.exists()) {
            aa0.a(TAG, "readPackageVersion", new Object[0]);
            return;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            try {
                FileInputStream fileInputStream2 = new FileInputStream(file);
                try {
                    properties.load(fileInputStream2);
                    gp.a(fileInputStream2);
                } catch (IOException e) {
                    e = e;
                    fileInputStream = fileInputStream2;
                    aa0.a(TAG, "readDeviceId exception:", e, new Object[0]);
                    gp.a(fileInputStream);
                    String property = properties.getProperty("version");
                    this.mPackageVersion = property;
                    aa0.a(TAG, "readPackageVersion:{?}", property);
                    sh.c().b("dynamicFuncPackageVersion", this.mPackageVersion);
                } catch (Throwable th) {
                    th = th;
                    fileInputStream = fileInputStream2;
                    gp.a(fileInputStream);
                    throw th;
                }
            } catch (IOException e2) {
                e = e2;
            }
            String property2 = properties.getProperty("version");
            this.mPackageVersion = property2;
            aa0.a(TAG, "readPackageVersion:{?}", property2);
            sh.c().b("dynamicFuncPackageVersion", this.mPackageVersion);
        } catch (Throwable th2) {
            th = th2;
        }
    }

    private void registerListener() {
        aa0.a(TAG, "registerListener", new Object[0]);
        for (int i : this.MODULE_TYPE_ARRAY) {
            fi a2 = yh.p().a(i);
            if (a2 != null) {
                for (int i2 = 0; i2 < a2.b().size(); i2++) {
                    hi valueAt = a2.b().valueAt(i2);
                    if ((valueAt instanceof hi.c) && valueAt.b()) {
                        ((hi.c) valueAt).a();
                    }
                }
            }
        }
    }

    private boolean releaseDexFiles(String str) {
        aa0.a(TAG, "releaseDexFiles start", new Object[0]);
        File file = new File(this.mExternalAdapterDir + CLOUD_FUNC_REPOSITORY_NAME);
        if (!file.exists()) {
            file = new File(this.mExternalAdapterDir + FUNC_REPOSITORY_NAME);
            if (!file.exists()) {
                aa0.a(TAG, "releaseDexFiles repository file not exist", new Object[0]);
                return false;
            }
        }
        aa0.a(TAG, "releaseDexFiles load file:{?}", file.getAbsolutePath());
        sh.c().b("dynamicFuncRepositorySize", file.length());
        FileInputStream fileInputStream = null;
        try {
            try {
                FileInputStream fileInputStream2 = new FileInputStream(file);
                try {
                    byte[] a2 = wh.a(fileInputStream2);
                    y90.a(fileInputStream2);
                    if (a2 != null && a2.length != 0) {
                        aa0.a(TAG, "releaseDexFiles decrypt", new Object[0]);
                        byte[] nativeConfigDecrypt = AndroidAdapterConfiger.nativeConfigDecrypt(a2, a2.length, null);
                        if (nativeConfigDecrypt != null && nativeConfigDecrypt.length != 0) {
                            aa0.a(TAG, "releaseDexFiles uncompressFiles", new Object[0]);
                            if (!wh.a(new ByteArrayInputStream(nativeConfigDecrypt), str)) {
                                aa0.a(TAG, "releaseDexFiles uncompressFiles fail", new Object[0]);
                                return false;
                            }
                            aa0.a(TAG, "releaseDexFiles end", new Object[0]);
                            return true;
                        }
                        aa0.a(TAG, "releaseDexFiles nativeConfigDecrypt fail", new Object[0]);
                        return false;
                    }
                    aa0.a(TAG, "releaseDexFiles file is empty", new Object[0]);
                    return false;
                } catch (Exception e) {
                    e = e;
                    fileInputStream = fileInputStream2;
                    aa0.a(TAG, "releaseDexFiles loadAdapterDatabase exception", e, new Object[0]);
                    y90.a(fileInputStream);
                    return false;
                } catch (Throwable th) {
                    th = th;
                    fileInputStream = fileInputStream2;
                    y90.a(fileInputStream);
                    throw th;
                }
            } catch (Exception e2) {
                e = e2;
            }
        } catch (Throwable th2) {
            th = th2;
        }
    }

    private void unRegisterListener() {
        aa0.a(TAG, "unRegisterListener", new Object[0]);
        for (int i : this.MODULE_TYPE_ARRAY) {
            fi a2 = yh.p().a(i);
            if (a2 != null) {
                for (int i2 = 0; i2 < a2.b().size(); i2++) {
                    hi valueAt = a2.b().valueAt(i2);
                    if ((valueAt instanceof hi.c) && valueAt.b()) {
                        ((hi.c) valueAt).b();
                    }
                }
            }
        }
    }

    public void collectionResult(int i, String str, String str2) {
        if (yh.p().h() && !oj.b(str)) {
            String a2 = yh.p().b().a(191, "");
            StringBuilder sb = new StringBuilder();
            sb.append("DynamicFuncResult=");
            sb.append(i);
            sb.append(",packageVersion=");
            sb.append(this.mPackageVersion);
            sb.append(",dynamicFuncDexName=");
            sb.append(a2);
            sb.append(",tag=");
            sb.append(str);
            if (!TextUtils.isEmpty(str2)) {
                str2 = str2.replace("[", "(").replace("]", ")").replace("'", "").replace("\"", "");
                sb.append(",appendInfo=");
                sb.append(str2);
            }
            aa0.a(TAG, "collectionResult, uploadKey:{?}, appendInfo:{?}", str, str2);
            oj.a(str, sb.toString());
        }
    }

    public DynamicFuncImplProxy getImplProxy() {
        return this.mImplProxy;
    }

    public void init(Context context) {
        aa0.a(TAG, "init", new Object[0]);
        this.mExternalAdapterDir = da0.b() + INNER_ADAPTER_DIR;
        if (context.getFilesDir() != null) {
            this.mInternalAdapterDir = context.getFilesDir().getAbsolutePath() + INNER_ADAPTER_DIR;
        } else {
            Log.e(TAG, "init, context.getFilesDir() is null");
            aa0.a(TAG, "init, context.getFilesDir() is null", new Object[0]);
        }
        wh.a(this.mExternalAdapterDir);
        wh.a(this.mInternalAdapterDir);
        this.mPackageVersion = sh.c().a("dynamicFuncPackageVersion", "");
        if (isNeedUpdateDex()) {
            clearDexFiles();
            if (releaseDexFiles(this.mInternalAdapterDir)) {
                readPackageVersion();
            }
        }
        aa0.a(TAG, "inited", new Object[0]);
    }

    public boolean isAvailable() {
        return this.mImplProxy != null;
    }

    public void onCleanup() {
        aa0.a(TAG, "cleanup", new Object[0]);
        DynamicFuncImplProxy dynamicFuncImplProxy = this.mImplProxy;
        if (dynamicFuncImplProxy != null) {
            dynamicFuncImplProxy.cleanup();
            unRegisterListener();
            this.mImplProxy.setAutoProxy(null);
            this.mImplProxy = null;
        }
    }

    public void onStartup() {
        aa0.a(TAG, "startup", new Object[0]);
        if (yh.p().h()) {
            String a2 = yh.p().b().a(191, "");
            aa0.a(TAG, "dynamicFuncDexName:{?}", a2);
            if (TextUtils.isEmpty(a2)) {
                return;
            }
            File file = new File(this.mInternalAdapterDir + a2);
            if (file.exists()) {
                DynamicFuncImplProxy build = DynamicFuncImplProxy.build(ee.A().f(), this.mInternalAdapterDir + a2);
                this.mImplProxy = build;
                if (build != null) {
                    build.setAutoProxy(new ei());
                    boolean startup = this.mImplProxy.startup();
                    if (startup) {
                        registerListener();
                    } else {
                        this.mImplProxy = null;
                    }
                    aa0.a(TAG, "onStartup, isSuccess={?}", Boolean.valueOf(startup));
                    collectionResult(!startup ? 1 : 0, "startup is " + startup, "");
                }
                sh.c().b();
                return;
            }
            aa0.a(TAG, "onStartup, dexFile:{?} not exist", file.getAbsoluteFile());
            collectionResult(1, "dex file not exist", "dex:" + a2);
        }
    }
}
