package com.autonavi.amapauto.framework;

/* loaded from: classes.dex */
public class LibraryLoader {
    public static final int LIBRARY_STATE_ERROR = 2;
    public static final int LIBRARY_STATE_LOAD = 1;
    public static final int LIBRARY_STATE_UNLOAD = 0;
    public static final int LIBRARY_TYPE_JAVA = 1;
    public static final int LIBRARY_TYPE_NATIVE = 0;

    public static void LoadSoByAuto(String str) {
        if (str.contains("/")) {
            System.load(str);
        } else {
            System.loadLibrary(str);
        }
    }

    public static native void nativeAddLibraryPath(String str, int i);

    public static native void nativeBlockLibrary(String str);

    public static native void nativeEnableHook(boolean z);

    public static native boolean nativeIsEnableHook();

    public static native int nativeLoadLibrary(String str);

    public static native void nativeLoadedLibrary(String str);

    public static native void nativeRegisterLibrary(String str, int i, String[] strArr);

    public static native void nativeRun();

    public static native void nativeSetOrder(String[] strArr);

    public static native void nativeUnblockLibrary(String str);

    public static native int nativeUnloadLibrary(String str);

    public void addLibraryPath(String str, int i) {
        nativeAddLibraryPath(str, i);
    }

    public void blockLibrary(String str) {
        nativeBlockLibrary(str);
    }

    public void enableHook(boolean z) {
        nativeEnableHook(z);
    }

    public boolean isEnableHook() {
        return nativeIsEnableHook();
    }

    public int loadLibrary(String str) {
        return nativeLoadLibrary(str);
    }

    public void loadedLibrary(String str) {
        nativeLoadedLibrary(str);
    }

    public void registerLibrary(String str, int i, String[] strArr) {
        nativeRegisterLibrary(str, i, strArr);
    }

    public void run() {
        nativeRun();
    }

    public void setOrder(String[] strArr) {
        nativeSetOrder(strArr);
    }

    public void unblockLibrary(String str) {
        nativeUnblockLibrary(str);
    }

    public int unloadLibrary(String str) {
        return nativeUnloadLibrary(str);
    }
}
