package com.autonavi.amapauto.jni;

import android.text.TextUtils;
import com.autonavi.amapauto.jni.config.AudioConfigData;
import com.autonavi.amapauto.jni.config.TextPlayTrackingData;
import com.autonavi.amapauto.jni.protocol.AndroidProtocolExe;
import com.autonavi.amapauto.protocol.model.client.ReqVolumeInfoQueryModel;
import defpackage.aa0;
import defpackage.bb0;
import defpackage.dx;
import defpackage.fv;
import defpackage.jp;
import defpackage.le;
import defpackage.mf;
import defpackage.pf;
import defpackage.rf;
import defpackage.tf;
import defpackage.uf;
import defpackage.v30;
import defpackage.vd;
import java.nio.ByteBuffer;

/* loaded from: classes.dex */
public class AndroidAudioControl {
    public static final String TAG = "AndroidAudioControl";
    public static final byte UNKNOWN_VOLUME = -1;
    public static boolean sMuteStatusSetForPhoneCalling = true;

    /* loaded from: classes.dex */
    public static class a implements Runnable {
        public final /* synthetic */ String a;
        public final /* synthetic */ int c;

        public a(String str, int i) {
            this.a = str;
            this.c = i;
        }

        @Override // java.lang.Runnable
        public void run() {
            if (TextUtils.isEmpty(this.a)) {
                tf.c(AndroidAudioControl.TAG, "ERROR playByMediaPlayer filepath is empty", new Object[0]);
            } else if (!this.a.startsWith(rf.q) && !this.a.startsWith(rf.r) && !this.a.endsWith(".mp3")) {
                rf.r().g().a(this.a, this.c);
            } else {
                rf.r().b().a(this.a, this.c);
            }
        }
    }

    public static void abandomFocusSystem() {
        aa0.a(TAG, "abandomFocusSystem ", new Object[0]);
        rf.r().a(0);
    }

    public static int getFilePlayState() {
        int i;
        try {
            i = rf.r().g().a();
        } catch (Exception e) {
            tf.c(TAG, "getFilePlayState Exception:{?}", e.getMessage());
            i = 1;
        }
        aa0.a(TAG, "getFilePlayState filePlayState:{?}", Integer.valueOf(i));
        return i;
    }

    public static int getPlayState() {
        if (rf.r().j()) {
            tf.c(TAG, "getPlayState isPhoneCalling", new Object[0]);
            return 5;
        }
        if (rf.u) {
            tf.c(TAG, "getPlayState is PLAYSTATE_LOSS_TRANS", new Object[0]);
            return 4;
        }
        return rf.r().f().a();
    }

    public static int getStreamType() {
        int c = rf.r().c();
        aa0.a(TAG, "getStreamType streamType:{?}", Integer.valueOf(c));
        return c;
    }

    public static int getSystemMaxVolume() {
        Exception e;
        int i;
        try {
            i = getSystemMaxVolumeFromStandardProtocol();
            if (i == -1) {
                try {
                    i = jp.I().w().getSystemMaxVolume();
                } catch (Exception e2) {
                    e = e2;
                    aa0.a(TAG, "getSystemMaxVolume:", e, new Object[0]);
                    aa0.a(TAG, "getSystemMaxVolume maxVol:{?}", Integer.valueOf(i));
                    tf.a(TAG, "get System Volume maxVol:{?}", Integer.valueOf(i));
                    return i;
                }
            }
        } catch (Exception e3) {
            e = e3;
            i = -1;
        }
        aa0.a(TAG, "getSystemMaxVolume maxVol:{?}", Integer.valueOf(i));
        tf.a(TAG, "get System Volume maxVol:{?}", Integer.valueOf(i));
        return i;
    }

    public static int getSystemMaxVolumeFromStandardProtocol() {
        ReqVolumeInfoQueryModel reqVolumeInfoQueryModel = (ReqVolumeInfoQueryModel) fv.e().a(new ReqVolumeInfoQueryModel(), ReqVolumeInfoQueryModel.class);
        if (reqVolumeInfoQueryModel == null) {
            return -1;
        }
        int volumeMax = reqVolumeInfoQueryModel.getVolumeMax();
        aa0.a(TAG, "get volume max {?} from standard protocol ", Integer.valueOf(volumeMax));
        return volumeMax;
    }

    public static int getSystemVolume() {
        Exception e;
        int i;
        try {
            i = getSystemVolumeFromStandardProtocol();
            if (i == -1) {
                try {
                    i = jp.I().w().getSystemVolume();
                } catch (Exception e2) {
                    e = e2;
                    aa0.a(TAG, "getSystemVolume:", e, new Object[0]);
                    tf.a(TAG, "get System Volume value:{?}", Integer.valueOf(i));
                    return i;
                }
            }
        } catch (Exception e3) {
            e = e3;
            i = -1;
        }
        tf.a(TAG, "get System Volume value:{?}", Integer.valueOf(i));
        return i;
    }

    public static int getSystemVolumeFromStandardProtocol() {
        ReqVolumeInfoQueryModel reqVolumeInfoQueryModel = (ReqVolumeInfoQueryModel) fv.e().a(new ReqVolumeInfoQueryModel(), ReqVolumeInfoQueryModel.class);
        if (reqVolumeInfoQueryModel == null) {
            return -1;
        }
        aa0.a(TAG, "get volume level start  from standard protocol ", new Object[0]);
        int volumeLevel = reqVolumeInfoQueryModel.getVolumeLevel();
        aa0.a(TAG, "get volume level end {?} from standard protocol ", Integer.valueOf(volumeLevel));
        return volumeLevel;
    }

    public static int getTextToSpeechState() {
        return mf.i().a();
    }

    public static int init(int i) {
        aa0.a(TAG, "init sampleRate:{?}", Integer.valueOf(i));
        ByteBuffer a2 = rf.r().f().a(i);
        nativeCacheDirectBufferAddress(a2);
        tf.c(TAG, "init capacity:{?}", Integer.valueOf(a2.capacity()));
        return a2.capacity();
    }

    public static boolean isMuteStatusSetForPhoneCalling() {
        return sMuteStatusSetForPhoneCalling;
    }

    public static boolean jniGetUseAudioTrack() {
        AudioConfigData a2 = rf.r().a();
        int streamType = a2.getStreamType();
        boolean z = a2.isUseAudioTrack;
        if (streamType > 5 || a2.isUserHighVersionAudioApi) {
            z = true;
        }
        aa0.a(TAG, "jniGetUseAudioTrack streamType:{?} isNeedUseAudioTrack:{?} isUserHighVersionAudioApi:{?}", Integer.valueOf(streamType), Boolean.valueOf(z), Boolean.valueOf(a2.isUserHighVersionAudioApi));
        return z;
    }

    public static void jniMuteStatusSetForPhoneCalling(boolean z) {
        sMuteStatusSetForPhoneCalling = z;
    }

    public static native void nativeCacheDirectBufferAddress(ByteBuffer byteBuffer);

    public static native void nativeChangeVolume(int i);

    public static native int nativeGetTtsCacheBufferSize();

    public static native void nativeNotifyVoiceBlockDynamic();

    public static native void nativeTextPlayAbnormal(TextPlayTrackingData textPlayTrackingData);

    public static native void notifyPlayStateChange(int i);

    public static void notifyTTSPlayStatus(int i) {
        tf.c(TAG, " notifyTTSPlayStatus status:{?}", Integer.valueOf(i));
        rf.r().f().b(i);
    }

    public static native void onStreamVolumeChange(int i);

    public static void playByAudioTrack(int i) {
        boolean nativeIsMute = GAdaAndroid.nativeIsMute();
        boolean z = rf.r().a().isVolumeZeroNeedPauseBackgroundNoises;
        boolean z2 = nativeIsMute && z;
        boolean a2 = le.j().a();
        boolean z3 = z2 || a2;
        aa0.a(TAG, "playByAudioTrack audioLen:{?}  isNativeMute:{?} isNeddZeroVolPause:{?} isNeedPlayMute:{?} imMixModeTtsPause:{?}", Integer.valueOf(i), Boolean.valueOf(nativeIsMute), Boolean.valueOf(z), Boolean.valueOf(z3), Boolean.valueOf(a2));
        uf f = rf.r().f();
        f.a(z3);
        f.c(i);
    }

    public static void playByMediaPlayer(String str, int i) {
        aa0.a(TAG, "playByMediaPlayer volumPercent:{?} filepath:{?} ", Integer.valueOf(i), str);
        bb0.d(new a(str, i));
    }

    public static void playByTextToSpeech(String str, int i) {
        aa0.a(TAG, "playByTextToSpeech text:{?}, volumPercent:{?}", str, Integer.valueOf(i));
        mf.i().a(i);
        mf.i().a(str);
    }

    public static void releaseMediaPlayer(int i) {
        aa0.a(TAG, "releaseMediaPlayer ", new Object[0]);
        if (1 == i) {
            rf.r().b().b();
        } else {
            rf.r().g().b();
        }
    }

    public static int requestFocusSystem(int i) {
        int a2 = rf.r().a(i, 0);
        boolean z = rf.r().a().isPlayWithoutFocusSucced;
        aa0.a(TAG, "requestFocusSystem durationHint:{?} obtainCode:{?} isPlayWithoutFocusSucced:{?}", Integer.valueOf(i), Integer.valueOf(a2), Boolean.valueOf(z));
        if (a2 == 0 && !z) {
            pf.a(2, "streamType:" + rf.r().c() + ",audioMode:" + i);
        }
        if (1 == a2) {
            rf.u = false;
        }
        return a2;
    }

    public static void setIsUseSystemTTS(boolean z) {
        mf.i().a(z);
    }

    public static void setMuteState(boolean z) {
        tf.b(TAG, "setMuteState:{?}", Boolean.valueOf(z));
        AndroidProtocolExe.setNaviMuteModel(0, 0, z);
    }

    public static void setStreamType(int i) {
        aa0.a(TAG, "setStreamType streamType:{?}", Integer.valueOf(i));
        rf.r().i(i);
    }

    public static void setSystemVolume(int i) {
        tf.a(TAG, "set System Volume value:{?}", Integer.valueOf(i));
        try {
            jp.I().w().setSystemVolume(i, 0);
            fv.e().a((dx) new v30(i));
        } catch (Exception e) {
            aa0.a(TAG, "setSystemVolume:", e, new Object[0]);
        }
    }

    public static void setTempMuteState(boolean z) {
        tf.b(TAG, "setTempMuteState:{?}", Boolean.valueOf(z));
        AndroidProtocolExe.setNaviMuteModel(0, 1, z);
    }

    public static void stopAudioTrack() {
        stopAudioTrack(false);
    }

    public static void stopTextToSpeech() {
        mf.i().h();
    }

    public static void textPlayEventTracking(int i, String str) {
        TextPlayTrackingData textPlayTrackingData = new TextPlayTrackingData();
        textPlayTrackingData.iSessionId = pf.e();
        textPlayTrackingData.ePlaynode = i;
        textPlayTrackingData.strMessage = str;
        if (i == 201000012) {
            textPlayTrackingData.isHappyEnd = true;
            textPlayTrackingData.isAbEnd = false;
        } else if (i == 201000011) {
            textPlayTrackingData.isHappyEnd = false;
            textPlayTrackingData.isAbEnd = false;
        } else {
            textPlayTrackingData.isHappyEnd = false;
            textPlayTrackingData.isAbEnd = true;
        }
        textPlayEventTracking(textPlayTrackingData);
    }

    public static void uninit() {
        aa0.a(TAG, "uninit ", new Object[0]);
    }

    public static native void updateAudioFocusChange(int i);

    public static void stopAudioTrack(boolean z) {
        tf.c(TAG, " stopAudioTrack [stop_TTS] stop by Native", new Object[0]);
        rf.r().f().b(z);
    }

    public static boolean textPlayEventTracking(TextPlayTrackingData textPlayTrackingData) {
        if (!vd.l()) {
            aa0.a(TAG, "textPlayEventTracking: current version below 500 and return false", new Object[0]);
            return false;
        }
        if (textPlayTrackingData == null) {
            aa0.a(TAG, "textPlayEventTracking: playTrackingData is null and return false", new Object[0]);
            return false;
        }
        pf.a(textPlayTrackingData);
        int i = textPlayTrackingData.ePlaynode;
        if (i != 201000000 && (i < 201001000 || i == 201007006 || i == 201007007)) {
            return true;
        }
        nativeTextPlayAbnormal(textPlayTrackingData);
        return true;
    }
}
