package com.autonavi.amapauto.jni;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import defpackage.aa0;
import defpackage.ee;
import defpackage.jp;
import defpackage.o90;
import defpackage.se;
import defpackage.x6;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;

/* loaded from: classes.dex */
public class AndroidNotificationNative {
    public static final String ACTION_NOTICE_RECEIVE = "com.autonavi.amapauto.intent.action_notify_reveive";
    public static final String ACTION_NOTICE_SLICE_RECEIVE = "com.autonavi.amapauto.intent.action_notify_slice_reveive";
    public static final String ACTION_SLICE_THIRD_APP_CLICKED = "com.autonavi.amapauto.slice.thirdapp.action_slice_third_app_clicked";
    public static final String CHANNEL_NAME = "AndroidNotification";
    public static final int CLEAR_ALL_SLICE_ACTION = -9;
    public static final String PARAM_NOTICE_ID = "notice_id";
    public static final String PARAM_REQUEST_CODE = "request_code";
    public static final String TAG = "AndroidNotificationNative";
    public static final String CHANNEL_ID = String.valueOf(1095582032);
    public static PendingIntent sNotifyReceivePendingIntent = null;
    public static HashMap<Integer, PendingIntent> sPendingIntentHashMap = new HashMap<>();
    public static HashMap<Integer, PendingIntent> sSlicePendingIntentHashMap = new HashMap<>();
    public static HashMap<Integer, c> sSliceNoticeActionHashMap = new HashMap<>();
    public static a sAutoNotifyClickReceiver = new a();
    public static b sAutoNotifySliceClickReceiver = new b();

    /* loaded from: classes.dex */
    public static class a extends BroadcastReceiver {
        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (!o90.a(AndroidNotificationNative.getContext())) {
                aa0.a("AutoNotifyClickReceiver", "child over", new Object[0]);
                return;
            }
            int intExtra = intent.getIntExtra(AndroidNotificationNative.PARAM_REQUEST_CODE, -1);
            int intExtra2 = intent.getIntExtra(AndroidNotificationNative.PARAM_NOTICE_ID, -1);
            aa0.a("AutoNotifyClickReceiver", "request code " + intExtra + " noticeId " + intExtra2, new Object[0]);
            AndroidNotificationNative.collapseStatusBar();
            AndroidNotificationNative.nativeNoticeIntentReceive(intExtra2);
        }
    }

    /* loaded from: classes.dex */
    public static class b extends BroadcastReceiver {
        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (!o90.a(AndroidNotificationNative.getContext())) {
                aa0.a("AutoNotifySliceClickReceiver", "child over", new Object[0]);
                return;
            }
            int intExtra = intent.getIntExtra(AndroidNotificationNative.PARAM_REQUEST_CODE, -1);
            int intExtra2 = intent.getIntExtra(AndroidNotificationNative.PARAM_NOTICE_ID, -1);
            aa0.a("AutoNotifySliceClickReceiver", "request code " + intExtra + " noticeId " + intExtra2, new Object[0]);
            c cVar = (c) AndroidNotificationNative.sSliceNoticeActionHashMap.get(Integer.valueOf(intExtra2));
            if (cVar != null && cVar.d) {
                aa0.a("AutoNotifySliceClickReceiver", "slcie 4 third app is clicked noticeId:{?}", Integer.valueOf(intExtra2));
                Bundle bundle = new Bundle();
                bundle.putInt(AndroidNotificationNative.ACTION_SLICE_THIRD_APP_CLICKED, cVar.a);
                se.a(AndroidNotificationNative.ACTION_SLICE_THIRD_APP_CLICKED, bundle);
                return;
            }
            AndroidNotificationNative.nativeSliceNoticeIntentReceive(intExtra2);
        }
    }

    /* loaded from: classes.dex */
    public static class c {
        public int a;
        public String b;
        public String c;
        public boolean d;

        public c(int i, String str, String str2) {
            this.a = i;
            this.b = str;
            this.c = str2;
        }

        public String toString() {
            return "SliceNoticeAction{noticeId=" + this.a + ", title='" + this.b + "', content='" + this.c + "'}";
        }
    }

    public static void bindNotifyReceiver() {
        boolean a2 = o90.a(getContext());
        aa0.a(TAG, "bindNotifyClickReceiver " + a2, new Object[0]);
        if (a2) {
            try {
                List<ResolveInfo> queryBroadcastReceivers = getContext().getPackageManager().queryBroadcastReceivers(new Intent(ACTION_NOTICE_RECEIVE), 0);
                if (queryBroadcastReceivers == null || queryBroadcastReceivers.isEmpty()) {
                    ee.A().e().registerReceiver(sAutoNotifyClickReceiver, new IntentFilter(ACTION_NOTICE_RECEIVE));
                    aa0.a(TAG, "registerReceiver success", new Object[0]);
                }
                aa0.a(TAG, "registerReceiver done", new Object[0]);
            } catch (Throwable th) {
                th.printStackTrace();
                aa0.a(TAG, "registerReceiver exception", th, new Object[0]);
            }
        }
    }

    public static void bindNotifySliceReceiver() {
        boolean a2 = o90.a(getContext());
        aa0.a(TAG, "bindNotifySliceReceiver " + a2, new Object[0]);
        if (a2) {
            try {
                List<ResolveInfo> queryBroadcastReceivers = getContext().getPackageManager().queryBroadcastReceivers(new Intent(ACTION_NOTICE_SLICE_RECEIVE), 0);
                if (queryBroadcastReceivers == null || queryBroadcastReceivers.isEmpty()) {
                    ee.A().e().registerReceiver(sAutoNotifySliceClickReceiver, new IntentFilter(ACTION_NOTICE_SLICE_RECEIVE));
                    aa0.a(TAG, "registerReceiver success", new Object[0]);
                }
                aa0.a(TAG, "registerReceiver done", new Object[0]);
            } catch (Throwable th) {
                th.printStackTrace();
                aa0.a(TAG, "registerReceiver exception", th, new Object[0]);
            }
        }
    }

    public static void collapseStatusBar() {
        Method method;
        Object systemService = getContext().getSystemService("statusbar");
        if (systemService == null) {
            return;
        }
        try {
            Class<?> cls = Class.forName("android.app.StatusBarManager");
            if (Build.VERSION.SDK_INT <= 16) {
                method = cls.getMethod("collapse", new Class[0]);
            } else {
                method = cls.getMethod("collapsePanels", new Class[0]);
            }
            if (method != null) {
                method.setAccessible(true);
                method.invoke(systemService, new Object[0]);
            }
        } catch (Exception e) {
            aa0.a(TAG, "when collapseStatusBar occur an error!", e, new Object[0]);
        }
    }

    public static void createNotificationChannel(boolean z, String str) {
        NotificationManager notificationManager = getNotificationManager();
        if (notificationManager == null || Build.VERSION.SDK_INT < 26) {
            return;
        }
        String str2 = CHANNEL_ID;
        if (TextUtils.isEmpty(str)) {
            str = CHANNEL_NAME;
        }
        NotificationChannel notificationChannel = new NotificationChannel(str2, str, z ? 4 : 0);
        notificationChannel.enableLights(false);
        notificationChannel.enableVibration(false);
        notificationChannel.setShowBadge(false);
        notificationManager.createNotificationChannel(notificationChannel);
    }

    public static Context getContext() {
        return ee.A().f();
    }

    public static PendingIntent getExtPendingIntent(int i) {
        PendingIntent pendingIntent = sPendingIntentHashMap.get(Integer.valueOf(i));
        if (pendingIntent == null) {
            Intent intent = new Intent();
            intent.setAction(ACTION_NOTICE_RECEIVE);
            int nextInt = new SecureRandom().nextInt(10000);
            intent.putExtra(PARAM_REQUEST_CODE, nextInt);
            intent.putExtra(PARAM_NOTICE_ID, i);
            aa0.a(TAG, "request code " + nextInt + " noticeId " + i, new Object[0]);
            try {
                return PendingIntent.getBroadcast(getContext(), nextInt, intent, Build.VERSION.SDK_INT >= 31 ? 201326592 : 134217728);
            } catch (RuntimeException e) {
                aa0.a(TAG, "ocuur a error ", e, new Object[0]);
                return pendingIntent;
            }
        }
        aa0.a(TAG, "reuse pending intent", new Object[0]);
        return pendingIntent;
    }

    public static NotificationManager getNotificationManager() {
        return (NotificationManager) getContext().getSystemService("notification");
    }

    public static PendingIntent getPendingIntent(int i) {
        if (sNotifyReceivePendingIntent == null) {
            Intent intent = new Intent();
            intent.setAction(ACTION_NOTICE_RECEIVE);
            int nextInt = new SecureRandom().nextInt(10000);
            intent.putExtra(PARAM_REQUEST_CODE, nextInt);
            intent.putExtra(PARAM_NOTICE_ID, i);
            aa0.a(TAG, "request code " + nextInt + " noticeId " + i, new Object[0]);
            try {
                sNotifyReceivePendingIntent = PendingIntent.getBroadcast(getContext(), nextInt, intent, Build.VERSION.SDK_INT >= 31 ? 201326592 : 134217728);
            } catch (RuntimeException e) {
                aa0.a(TAG, "ocuur a error ", e, new Object[0]);
            }
        } else {
            aa0.a(TAG, "reuse pending intent", new Object[0]);
        }
        return sNotifyReceivePendingIntent;
    }

    public static c getSliceNoticeAction(int i) {
        HashMap<Integer, c> hashMap = sSliceNoticeActionHashMap;
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(Integer.valueOf(i));
    }

    public static PendingIntent getSlicePendingIntent(int i) {
        PendingIntent pendingIntent = sSlicePendingIntentHashMap.get(Integer.valueOf(i));
        if (pendingIntent == null) {
            Intent intent = new Intent();
            intent.setAction(ACTION_NOTICE_SLICE_RECEIVE);
            int nextInt = new SecureRandom().nextInt(10000);
            intent.putExtra(PARAM_REQUEST_CODE, nextInt);
            intent.putExtra(PARAM_NOTICE_ID, i);
            aa0.a(TAG, "request code " + nextInt + " noticeId " + i, new Object[0]);
            try {
                return PendingIntent.getBroadcast(getContext(), nextInt, intent, Build.VERSION.SDK_INT >= 31 ? 201326592 : 134217728);
            } catch (RuntimeException e) {
                aa0.a(TAG, "ocuur a error ", e, new Object[0]);
                return pendingIntent;
            }
        }
        aa0.a(TAG, "reuse pending intent", new Object[0]);
        return pendingIntent;
    }

    public static void jniCancelSliceNotice(int i) {
        aa0.a(TAG, "jniCancelSliceNotice noticeId:{?}", Integer.valueOf(i));
        if (i == -9) {
            jp.I().f();
        } else {
            jp.I().k(i);
        }
    }

    public static void jniCancelSystemNotice(int i) {
        getNotificationManager().cancel(i);
    }

    public static void jniShowSliceNotice(String str, String str2, int i) {
        aa0.a(TAG, "jniShowSliceNotice title:{?}", Integer.valueOf(i));
        sSliceNoticeActionHashMap.put(Integer.valueOf(i), new c(i, str, str2));
        bindNotifySliceReceiver();
        jp.I().m(i);
    }

    public static void jniShowSystemNotice(String str, String str2, int i) {
        jniShowSystemNoticeExt(str, str2, null, i, false, 0, null, 0, null, 0, null);
    }

    public static void jniShowSystemNoticeExt(String str, String str2, String str3, int i, boolean z, int i2, String str4, int i3, String str5, int i4, String str6) {
        aa0.a(TAG, "jniShowSystemNoticeExt title:{?}, content:{?}, channelName:{?}, noticeId:{?}, ongoing:{?}, buttonOneNoticeId:{?}, buttonOneText:{?}, buttonTwoNoticeId:{?}, buttonTwoText:{?}", str, str2, str3, Integer.valueOf(i), Boolean.valueOf(z), Integer.valueOf(i2), str4, Integer.valueOf(i3), str5);
        bindNotifyReceiver();
        Context context = getContext();
        createNotificationChannel(true, str3);
        if (Build.VERSION.SDK_INT >= 26) {
            x6.c cVar = new x6.c(context, CHANNEL_ID);
            cVar.b(ee.A().h() > 0 ? ee.A().h() : ee.A().k());
            cVar.a(System.currentTimeMillis());
            cVar.c(str);
            cVar.b(str);
            cVar.a(str2);
            cVar.a(getExtPendingIntent(i));
            cVar.b(z);
            if (i2 > 0 && !TextUtils.isEmpty(str4)) {
                cVar.a(new x6.a.C0099a(null, str4, getExtPendingIntent(i2)).a());
            }
            if (i3 > 0 && !TextUtils.isEmpty(str5)) {
                cVar.a(new x6.a.C0099a(null, str5, getExtPendingIntent(i3)).a());
            }
            if (i4 > 0 && !TextUtils.isEmpty(str6)) {
                cVar.a(new x6.a.C0099a(null, str6, getExtPendingIntent(i4)).a());
            }
            getNotificationManager().notify(i, cVar.a());
        }
    }

    public static native void nativeNoticeIntentReceive(int i);

    public static native void nativeSliceNoticeIntentReceive(int i);

    public static void toShowSliceNotice4ThirdApp(String str, String str2, int i) {
        aa0.a(TAG, "jniShowSliceNotice title:{?}", Integer.valueOf(i));
        c cVar = new c(i, str, str2);
        cVar.d = true;
        sSliceNoticeActionHashMap.put(Integer.valueOf(i), cVar);
        bindNotifySliceReceiver();
        jp.I().m(i);
    }

    private void unbindReceiver() {
        if (o90.a(getContext())) {
            try {
                ee.A().e().unregisterReceiver(sAutoNotifyClickReceiver);
                aa0.a(TAG, "unregisterReceiver success", new Object[0]);
            } catch (Throwable th) {
                th.printStackTrace();
                aa0.a(TAG, "unregisterReceiver exception", th, new Object[0]);
            }
        }
    }
}
