package com.autonavi.amapauto.jni;

import android.view.Surface;
import androidx.annotation.Keep;
import defpackage.lr;
import defpackage.ps;
import defpackage.qs;
import defpackage.vd;

@Keep
/* loaded from: classes.dex */
public class MultiScreenNative {
    public static lr mObserver;

    public static Surface getMultiScreenUiSurface(int i) {
        ps b = qs.e().b(i);
        if (b != null) {
            return b.e();
        }
        return null;
    }

    public static ViewInfo getMultiScreenUiViewInfo(int i) {
        ps b = qs.e().b(i);
        if (b != null) {
            return b.f();
        }
        return null;
    }

    public static int onSurfaceChanged(int i, Surface surface, ViewInfo viewInfo) {
        lr lrVar;
        if (vd.n() && (lrVar = mObserver) != null) {
            return lrVar.b(i, surface, viewInfo);
        }
        return surfaceChanged(i, surface, viewInfo);
    }

    public static int onSurfaceCreated(int i, Surface surface, ViewInfo viewInfo) {
        lr lrVar;
        if (vd.n() && (lrVar = mObserver) != null) {
            return lrVar.a(i, surface, viewInfo);
        }
        return surfaceCreated(i, surface, viewInfo);
    }

    public static int onSurfaceDestroyed(int i) {
        lr lrVar;
        if (vd.n() && (lrVar = mObserver) != null) {
            return lrVar.a(i);
        }
        return surfaceDestroyed(i);
    }

    public static void onSurfaceStatus(int i, int i2) {
        lr lrVar;
        if (vd.n() && (lrVar = mObserver) != null) {
            lrVar.a(i, i2);
        } else {
            surfaceStatus(i, i2);
        }
    }

    public static void onTouchEvent(int i, int[] iArr, float[] fArr, float[] fArr2, int i2) {
        lr lrVar;
        if (vd.n() && (lrVar = mObserver) != null) {
            lrVar.a(i, iArr, fArr, fArr2, i2);
        } else {
            onTouchEventNative(i, iArr, fArr, fArr2, i2);
        }
    }

    public static native void onTouchEventNative(int i, int[] iArr, float[] fArr, float[] fArr2, int i2);

    public static void setMulitScreenObserver(lr lrVar) {
        mObserver = lrVar;
    }

    public static native int surfaceChanged(int i, Surface surface, ViewInfo viewInfo);

    public static native int surfaceCreated(int i, Surface surface, ViewInfo viewInfo);

    public static native int surfaceDestroyed(int i);

    public static native void surfaceStatus(int i, int i2);
}
