package com.autonavi.amapauto.jni;

import android.text.TextUtils;
import com.autonavi.amapauto.jni.protocol.AndroidProtocolExe;
import com.autonavi.amapauto.location.model.LocGnss;
import com.autonavi.amapauto.location.model.LocMMFeedbackInfo;
import com.autonavi.amapauto.location.model.LocModeType;
import com.autonavi.amapauto.location.model.LocMountAngle;
import com.autonavi.amapauto.location.model.LocSignData;
import com.autonavi.amapauto.location.model.PosWorkPath;
import defpackage.aa0;
import defpackage.ee;
import defpackage.jp;
import defpackage.t90;
import defpackage.td;
import defpackage.w80;

/* loaded from: classes.dex */
public class PosService {
    public static LocSignData mCILocSignData;

    public static void drCalibration(int i) {
        aa0.a("PosService", "drCalibration type={?}", Integer.valueOf(i));
        nativeDrCalibration(i);
    }

    public static String getLocRelatedInfo() {
        String c = t90.c();
        aa0.a("PosService", "getLocRelatedInfo = {?}", c);
        if (TextUtils.isEmpty(c)) {
            AndroidProtocolExe.sendAutoStatus(318);
        }
        return c;
    }

    public static LocMountAngle getMountAngleInfo() {
        aa0.a("PosService", "getMountAngleInfo", new Object[0]);
        return jp.I().e();
    }

    public static long init(PosWorkPath posWorkPath, LocModeType locModeType) {
        return nativeInit(posWorkPath, locModeType);
    }

    public static native void nativeDrCalibration(int i);

    public static native long nativeInit(PosWorkPath posWorkPath, LocModeType locModeType);

    public static native void nativeSetNmeaInfo(String str, long j);

    public static native void nativeSetSignInfo(LocSignData locSignData);

    public static void onMapMatchFeedbackUpdate(Object obj) {
        LocMMFeedbackInfo locMMFeedbackInfo = (LocMMFeedbackInfo) obj;
        aa0.a("PosService", "onMapMatchFeedbackUpdate:locMMFeedbackInfo={?}", locMMFeedbackInfo.toString());
        w80 l = ee.A().l();
        if (l != null) {
            l.onMapMatchFeedbackUpdate(locMMFeedbackInfo);
        }
    }

    public static void setSignInfo(LocSignData locSignData) {
        if (td.a && locSignData != null) {
            mCILocSignData = locSignData;
            LocGnss locGnss = locSignData.gnss;
            if (locGnss != null) {
                aa0.a("PosService", "LocSignData time:{?}-{?}-{?}-{?}-{?}-{?}", Integer.valueOf(locGnss.year), Integer.valueOf(locGnss.month), Integer.valueOf(locGnss.day), Integer.valueOf(locGnss.hour), Integer.valueOf(locGnss.minute), Integer.valueOf(locGnss.second));
            }
        }
        nativeSetSignInfo(locSignData);
    }
}
