package com.autonavi.amapauto.jni;

import android.app.ActivityOptions;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Build;
import android.os.Parcel;
import android.text.TextUtils;
import defpackage.aa0;
import defpackage.ee;

/* loaded from: classes.dex */
public class RequestDisplayMoveFront {
    public static final int MULTI_SCREEN_CLUSTER = 1001;
    public static final int MULTI_SCREEN_CODRIVER = 1002;
    public static final int MULTI_SCREEN_CODRIVER_DISPLAY_ID = 2;
    public static final int MULTI_SCREEN_MAIN = 1000;
    public static final int MULTI_SCREEN_MAIN_DISPLAY_ID = 0;
    public static final int MULTI_SCREEN_SDS = 1003;
    public static final String TAG = "RequestDisplayMoveFront";

    public static Parcel notifyDisplayMoveFront(Parcel parcel) {
        parcel.setDataPosition(0);
        ResponseMoveFrontParams notifyDisplayMoveFrontImpl = notifyDisplayMoveFrontImpl(RequestMoveFrontParams.CREATOR.createFromParcel(parcel));
        parcel.recycle();
        if (notifyDisplayMoveFrontImpl == null) {
            return null;
        }
        Parcel obtain = Parcel.obtain();
        notifyDisplayMoveFrontImpl.writeToParcel(obtain, 0);
        obtain.setDataPosition(0);
        return obtain;
    }

    public static ResponseMoveFrontParams notifyDisplayMoveFrontImpl(RequestMoveFrontParams requestMoveFrontParams) {
        aa0.a(TAG, "notifyDisplayMoveFrontImpl requestMoveFrontParams:{?}", requestMoveFrontParams);
        ResponseMoveFrontParams responseMoveFrontParams = new ResponseMoveFrontParams();
        if (requestMoveFrontParams == null) {
            return responseMoveFrontParams;
        }
        responseMoveFrontParams.a = requestMoveFrontParams.a;
        String str = null;
        switch (requestMoveFrontParams.c) {
            case 1000:
                str = "com.autonavi.amapauto.MainMapActivity";
                break;
            case 1001:
                str = "com.autonavi.amapauto.business.factory.preassemble.activityview.ClusterActivity";
                break;
            case 1002:
                str = "com.autonavi.amapauto.business.factory.preassemble.activityview.CodriverActivity";
                break;
            case 1003:
                str = "com.autonavi.amapauto.business.factory.preassemble.activityview.SDSActivity";
                break;
        }
        if (!TextUtils.isEmpty(str)) {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(ee.A().f().getPackageName(), str));
            intent.addFlags(268435456);
            if (Build.VERSION.SDK_INT >= 26 && requestMoveFrontParams.c == 1002) {
                ActivityOptions makeBasic = ActivityOptions.makeBasic();
                int i = requestMoveFrontParams.d;
                if (i <= 0) {
                    i = 2;
                }
                ee.A().f().startActivity(intent, makeBasic.setLaunchDisplayId(i).toBundle());
            } else if (Build.VERSION.SDK_INT >= 26 && requestMoveFrontParams.c == 1000) {
                ee.A().f().startActivity(intent, ActivityOptions.makeBasic().setLaunchDisplayId(0).toBundle());
            } else {
                ee.A().f().startActivity(intent);
            }
            responseMoveFrontParams.c = true;
        }
        aa0.a(TAG, "notifyDisplayMoveBackImpl requestId:" + responseMoveFrontParams.a + ",success=" + responseMoveFrontParams.c, new Object[0]);
        return responseMoveFrontParams;
    }
}
