package com.autonavi.amapauto.jni;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Parcel;
import defpackage.aa0;
import defpackage.ee;
import defpackage.ic0;
import defpackage.sh0;

/* loaded from: classes.dex */
public class RoadMapInteract {
    public static final String TAG = "RoadMapInteract";
    public static a floatHandler;
    public static a widgetHandler = ic0.a;

    /* loaded from: classes.dex */
    public interface a {
        void a(byte[] bArr, int i, int i2);
    }

    public static Bitmap getCustomRoundBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap createBitmap = Bitmap.createBitmap(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
        Canvas canvas = new Canvas(createBitmap);
        float dimensionPixelSize = ee.A().f().getResources().getDimensionPixelSize(sh0.auto_dimen2_12);
        float[] fArr = {0.0f, 0.0f, 0.0f, 0.0f, dimensionPixelSize, dimensionPixelSize, dimensionPixelSize, dimensionPixelSize};
        Paint paint = new Paint();
        paint.setAlpha(230);
        Path path = new Path();
        path.addRoundRect(new RectF(0.0f, 0.0f, createBitmap.getWidth(), createBitmap.getHeight()), fArr, Path.Direction.CW);
        canvas.clipPath(path);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        canvas.save();
        canvas.restore();
        return createBitmap;
    }

    public static void notifyRoadMapImg(Parcel parcel) {
        parcel.setDataPosition(0);
        RoadMapImgResponse createFromParcel = RoadMapImgResponse.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        notifyRoadMapImgImpl(createFromParcel);
    }

    public static void notifyRoadMapImgImpl(RoadMapImgResponse roadMapImgResponse) {
        a aVar;
        aa0.a(TAG, "notifyRoadMapImgImpl roadMapImgResponse:{?}", roadMapImgResponse);
        if (roadMapImgResponse != null) {
            int i = roadMapImgResponse.a;
            if (i == 0 || i == 1) {
                a aVar2 = floatHandler;
                if (aVar2 != null) {
                    aVar2.a(roadMapImgResponse.c, roadMapImgResponse.d, roadMapImgResponse.e);
                    return;
                }
                return;
            }
            if (i == 2 && (aVar = widgetHandler) != null) {
                aVar.a(roadMapImgResponse.c, roadMapImgResponse.d, roadMapImgResponse.e);
            }
        }
    }

    public static native void sendRoadMapVisible(Parcel parcel);

    public static void sendRoadMapVisibleImpl(RoadMapVisibleRequest roadMapVisibleRequest) {
        aa0.a(TAG, "sendRoadMapVisibleImpl roadMapVisibleRequest:{?}", roadMapVisibleRequest);
        if (roadMapVisibleRequest != null) {
            Parcel obtain = Parcel.obtain();
            roadMapVisibleRequest.writeToParcel(obtain, 0);
            obtain.setDataPosition(0);
            sendRoadMapVisible(obtain);
            obtain.recycle();
        }
    }
}
