package com.autonavi.amapauto.jni.ehp;

import android.os.Bundle;
import android.os.Parcel;
import defpackage.aa0;
import defpackage.se;
import java.util.List;
import java.util.Set;

/* loaded from: classes.dex */
public class AndroidEHPDataProviderNative {
    public static final String BUNDLE_KEYS = "keys";
    public static final String BUNDLE_METADATA = "metadata";
    public static byte CLASS_NAME_BOOL = 4;
    public static byte CLASS_NAME_BUNDLE = 7;
    public static byte CLASS_NAME_CHARPTR = 6;
    public static byte CLASS_NAME_DOUBLE = 3;
    public static byte CLASS_NAME_FLOAT = 2;
    public static byte CLASS_NAME_INTEGER_32 = 0;
    public static byte CLASS_NAME_INTEGER_64 = 1;
    public static byte CLASS_NAME_PARCELABLE = 8;
    public static byte CLASS_NAME_PARCELABLE_LIST = 9;
    public static byte CLASS_NAME_STRING = 5;
    public static int POSITIONING_UNKNOWN = -100000;
    public static final String TAG = "AndroidEHPDataProviderNative";
    public static a sOnConsumptionResultListener;
    public static b sOnDisplayTileDataChangeListener;
    public static c sOnLaneGroupDataChangeListener;
    public static d sOnLinksDataChangeListener;
    public static e sOnMetadataChangeListener;
    public static f sOnRegionDataChangeListener;

    /* loaded from: classes.dex */
    public interface a {
        void a(ConsumptionResult consumptionResult);
    }

    /* loaded from: classes.dex */
    public interface b {
        void a(int i, int i2, List<DisplayTile> list);
    }

    /* loaded from: classes.dex */
    public interface c {
        void a(int i, int i2, List<LaneGroup> list);
    }

    /* loaded from: classes.dex */
    public interface d {
        void a(int i, int i2, List<PsdLink> list);
    }

    /* loaded from: classes.dex */
    public interface e {
        void a(int i, EhpProviderMetadata ehpProviderMetadata);
    }

    /* loaded from: classes.dex */
    public interface f {
        void a(int i, EHPRegion eHPRegion);
    }

    public static Bundle decorateBundle(Bundle bundle) {
        Set<String> keySet = bundle.keySet();
        byte[] bArr = new byte[keySet.size()];
        int i = 0;
        for (String str : keySet) {
            if (bundle.get(str) instanceof Integer) {
                bArr[i] = CLASS_NAME_INTEGER_32;
            } else if (bundle.get(str) instanceof Long) {
                bArr[i] = CLASS_NAME_INTEGER_64;
            } else if (bundle.get(str) instanceof Double) {
                bArr[i] = CLASS_NAME_DOUBLE;
            } else if (bundle.get(str) instanceof Boolean) {
                bArr[i] = CLASS_NAME_BOOL;
            } else if (bundle.get(str) instanceof String) {
                bArr[i] = CLASS_NAME_STRING;
            }
            i++;
        }
        bundle.putStringArray(BUNDLE_KEYS, (String[]) keySet.toArray(new String[0]));
        bundle.putByteArray(BUNDLE_METADATA, bArr);
        return bundle;
    }

    public static Bundle jniGetBundle(String str, Bundle bundle) {
        try {
            Bundle b2 = se.b(str, bundle);
            if (b2 == null) {
                aa0.a(TAG, "fetchForReceiver is null ", new Object[0]);
                return Bundle.EMPTY;
            }
            return decorateBundle(b2);
        } catch (RuntimeException e2) {
            aa0.a(TAG, "jniGetBundle RuntimeException action:" + str, e2, new Object[0]);
            return null;
        }
    }

    public static void jniNotifyBroadcastParcel(long j, Parcel parcel) {
        parcel.setDataPosition(0);
        se.a(j, parcel);
        parcel.recycle();
    }

    public static void jniNotifyBundle(String str, Bundle bundle) {
        try {
            se.a(str, bundle);
        } catch (RuntimeException e2) {
            aa0.a(TAG, "jniNotifyBundle RuntimeException action:" + str, e2, new Object[0]);
        }
    }

    public static void jniNotifyConsumptionResult(ConsumptionResult consumptionResult) {
        aa0.a(TAG, "jniNotifyConsumptionResult  jniNotifyConsumptionResult " + consumptionResult + " listener " + sOnConsumptionResultListener, new Object[0]);
        a aVar = sOnConsumptionResultListener;
        if (aVar != null) {
            aVar.a(consumptionResult);
        }
    }

    public static void jniNotifyDispalyTile(int i, int i2, List<DisplayTile> list) {
        b bVar = sOnDisplayTileDataChangeListener;
        if (bVar != null) {
            bVar.a(i, i2, list);
        }
    }

    public static void jniNotifyEhpProviderMetadata(int i, EhpProviderMetadata ehpProviderMetadata) {
        e eVar = sOnMetadataChangeListener;
        if (eVar == null) {
            aa0.a(TAG, "sOnMetadataChangeListener must not be null", (Throwable) null, new Object[0]);
        } else {
            eVar.a(i, ehpProviderMetadata);
        }
    }

    public static void jniNotifyLaneGroup(int i, int i2, List<LaneGroup> list) {
        c cVar = sOnLaneGroupDataChangeListener;
        if (cVar != null) {
            cVar.a(i, i2, list);
        }
    }

    public static void jniNotifyLinksData(int i, int i2, List<PsdLink> list) {
        d dVar = sOnLinksDataChangeListener;
        if (dVar != null) {
            dVar.a(i, i2, list);
        }
    }

    public static void jniNotifyRegionData(int i, EHPRegion eHPRegion) {
        aa0.a(TAG, i + " jniNotifyRegionData  region " + eHPRegion, new Object[0]);
        f fVar = sOnRegionDataChangeListener;
        if (fVar != null) {
            fVar.a(i, eHPRegion);
        }
    }

    public static native void nativeEhpProviderMetadata();

    public static native void nativeNotifyPositioningStatus(int i, int i2, int i3, int i4);

    public static native void nativeRequestDispalyTile(int i);

    public static native void nativeRequestLaneGroup(int i);

    public static native void nativeRequestLinks(int i);

    public static native void nativeRequestRegion(int i);

    public static native void nativeSendBundle(String str, Bundle bundle);

    public static native void nativeSendParcel(String str, Parcel parcel);

    public static native void nativeSetConsumptionChanged(Consumption consumption);

    public static void notifyPositioningStatus(int i, int i2, int i3, int i4) {
        nativeNotifyPositioningStatus(i, i2, i3, i4);
    }

    public static void requestDispalyTile(int i, b bVar) {
        sOnDisplayTileDataChangeListener = bVar;
        nativeRequestDispalyTile(i);
    }

    public static void requestLaneGroup(int i, c cVar) {
        sOnLaneGroupDataChangeListener = cVar;
        nativeRequestLaneGroup(i);
    }

    public static void requestLinks(int i, d dVar) {
        sOnLinksDataChangeListener = dVar;
        nativeRequestLinks(i);
    }

    public static void requestNotifyEhpProviderMetadata(e eVar) {
        sOnMetadataChangeListener = eVar;
        try {
            nativeEhpProviderMetadata();
        } catch (RuntimeException | UnsatisfiedLinkError e2) {
            aa0.b(TAG, "nativeEhpProviderMetadata exception~", e2, new Object[0]);
        }
        aa0.a(TAG, "nativeEhpProviderMetadata end", new Object[0]);
    }

    public static void requestRegion(int i, f fVar) {
        sOnRegionDataChangeListener = fVar;
        nativeRequestRegion(i);
    }

    public static void sendBundle(String str, Bundle bundle) {
        nativeSendBundle(str, decorateBundle(bundle));
    }

    public static void setOnConsumptionResultListener(a aVar) {
        sOnConsumptionResultListener = aVar;
    }

    public static void jniNotifyBroadcastParcel(String str, Parcel parcel) {
        try {
            parcel.setDataPosition(0);
            se.a(str, parcel);
            parcel.recycle();
        } catch (RuntimeException e2) {
            aa0.a(TAG, "jniNotifyBroadcastParcel RuntimeException action:" + str, e2, new Object[0]);
        }
    }
}
