package com.autonavi.amapauto.jni.protocol.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/* loaded from: classes.dex */
public class CoordinateInfoData {
    public int displayId;
    public List<GeoCoordinate> geoCoordinates;
    public int highlightPin;

    public int getDisplayId() {
        return this.displayId;
    }

    public List<GeoCoordinate> getGeoCoordinates() {
        if (this.geoCoordinates == null) {
            this.geoCoordinates = new ArrayList();
        }
        return this.geoCoordinates;
    }

    public int getHighlightPin() {
        return this.highlightPin;
    }

    public void setDisplayId(int i) {
        this.displayId = i;
    }

    public void setGeoCoordinates(List<GeoCoordinate> list) {
        this.geoCoordinates = list;
    }

    public void setHighlightPin(int i) {
        this.highlightPin = i;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CoordinateInfoData{highlightPin=");
        sb.append(this.highlightPin);
        sb.append(", displayId=");
        sb.append(this.displayId);
        sb.append(", geoCoordinates=");
        List<GeoCoordinate> list = this.geoCoordinates;
        sb.append(list == null ? "null" : Arrays.toString(list.toArray()));
        sb.append('}');
        return sb.toString();
    }
}
