package com.autonavi.amapauto.jni.protocol.data;

import defpackage.aa0;
import defpackage.jp;
import java.util.Arrays;

/* loaded from: classes.dex */
public class EnergyPredictionSysData {
    public static final String TAG = "EnergyPredictionSysData";
    public byte[] batteryTemperature;
    public long callContext;
    public int[] chargingMaxPower;
    public int chargingMode;
    public byte[] chargingSOCThresholds;
    public long clientID;

    public static void jniEnergyPredictionSysData(EnergyPredictionSysData energyPredictionSysData) {
        aa0.a(TAG, "jniEnergyPredictionSysData energyPredictionSysData:{?}", energyPredictionSysData);
        jp.I().a(energyPredictionSysData);
    }

    public String toString() {
        return "EnergyPredictionSysData{clientID=" + this.clientID + ", callContext=" + this.callContext + ", chargingMode=" + this.chargingMode + ", chargingSOCThresholds=" + Arrays.toString(this.chargingSOCThresholds) + ", batteryTemperature=" + Arrays.toString(this.batteryTemperature) + ", chargingMaxPower=" + Arrays.toString(this.chargingMaxPower) + '}';
    }
}
