package com.autonavi.amapauto.jni.protocol.data;

import com.autonavi.wireless.WirelessSDK;
import defpackage.aa0;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class JsonHeader {
    public static final int INT_TYPE_DISPATCH = 2;
    public static final int INT_TYPE_REQUEST = 0;
    public static final int INT_TYPE_REQUEST_SYNC = 3;
    public static final int INT_TYPE_RESPONSE = 1;
    public static final String MESSAGE_TYPE_DISPATCH = "dispatch";
    public static final String MESSAGE_TYPE_REQUEST = "request";
    public static final String MESSAGE_TYPE_REQUEST_SYNC = "requestsync";
    public static final String MESSAGE_TYPE_RESPONSE = "response";
    public JSONObject data;
    public String message;
    public String messageType;
    public boolean needResponse;
    public int protocolId;
    public String requestAuthor;
    public String requestCode;
    public String responseCode;
    public int statusCode;
    public String versionName;

    public static JsonHeader parseJsonToJsonHeader(JSONObject jSONObject) {
        JsonHeader jsonHeader = new JsonHeader();
        jsonHeader.requestCode = jSONObject.optString("requestCode");
        jsonHeader.responseCode = jSONObject.optString("responseCode");
        jsonHeader.needResponse = jSONObject.optBoolean("needResponse");
        jsonHeader.protocolId = jSONObject.optInt("protocolId");
        jsonHeader.versionName = jSONObject.optString("versionName");
        jsonHeader.requestAuthor = jSONObject.optString("requestAuthor");
        jsonHeader.message = jSONObject.optString("message");
        jsonHeader.messageType = jSONObject.optString("messageType");
        jsonHeader.statusCode = jSONObject.optInt("statusCode");
        jsonHeader.data = jSONObject.optJSONObject(WirelessSDK.KEY_DATA);
        return jsonHeader;
    }

    public static JSONObject parseJsonToJsonObj(String str) {
        try {
            return new JSONObject(str).optJSONObject(WirelessSDK.KEY_DATA);
        } catch (Exception e) {
            aa0.a("JsonHeader", e.getMessage(), e, new Object[0]);
            return null;
        }
    }

    public String toJsonString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("requestCode", this.requestCode);
            jSONObject.put("responseCode", this.responseCode);
            jSONObject.put("needResponse", this.needResponse);
            jSONObject.put("protocolId", this.protocolId);
            jSONObject.put("versionName", this.versionName);
            jSONObject.put("requestAuthor", this.requestAuthor);
            jSONObject.put("message", this.message);
            jSONObject.put("messageType", this.messageType);
            jSONObject.put("statusCode", this.statusCode);
            jSONObject.put(WirelessSDK.KEY_DATA, this.data);
        } catch (JSONException e) {
            aa0.a("JsonHeader", e.getMessage(), e, new Object[0]);
        }
        return jSONObject.toString();
    }

    public String toString() {
        return "JsonHeader{requestAuthor=" + this.requestAuthor + ", responseCode=" + this.responseCode + ", protocolId=" + this.protocolId + ", messageType=" + this.messageType + ", requestCode=" + this.requestCode + ", versionName=" + this.versionName + ", message=" + this.message + ", needResponse=" + this.needResponse + ", statusCode=" + this.statusCode + "}";
    }
}
