package com.autonavi.amapauto.jni.protocol.data;

import java.util.Arrays;
import java.util.List;

/* loaded from: classes.dex */
public class PowerInfoData {
    public double mAuxCost;
    public double[] mCurveCostList;
    public int mDriveMode;
    public int mEnergyUnit;
    public double mFerryRateCost;
    public double mHvBattEnergy;
    public boolean mIsCharging;
    public int mLowEnergyAlert;
    public double mMaxBatteryEnergy;
    public double mPercentOfResidualEnergy;
    public int mReachableDistance;
    public double[] mSlopeCostList;
    public double[] mSpeedCostList;
    public long mTimestamp;
    public int mTopSpeed;
    public double[] mTransCostList;
    public int mWeight;
    public PowerInfoExtensionData powerInfoExtensionData;
    public List<PowertrainLoss> powertrainLoss;

    public PowerInfoData() {
    }

    public double getAuxCost() {
        return this.mAuxCost;
    }

    public double getBatteryEnergy() {
        return this.mHvBattEnergy;
    }

    public double getBatteryPercentage() {
        return (this.mHvBattEnergy / this.mMaxBatteryEnergy) * 100.0d;
    }

    public int getChargeType() {
        return 1;
    }

    public double[] getCurveCostList() {
        return this.mCurveCostList;
    }

    public int getDriveMode() {
        return this.mDriveMode;
    }

    public int getEnergyUnit() {
        return this.mEnergyUnit;
    }

    public double getFerryrateCost() {
        return this.mFerryRateCost;
    }

    public int getLowEnergyAlert() {
        return this.mLowEnergyAlert;
    }

    public double getMaxBatteryEnergy() {
        return this.mMaxBatteryEnergy;
    }

    public double getPercentOfResidualEnergy() {
        return this.mPercentOfResidualEnergy;
    }

    public PowerInfoExtensionData getPowerInfoExtensionData() {
        return this.powerInfoExtensionData;
    }

    public List<PowertrainLoss> getPowertrainLoss() {
        return this.powertrainLoss;
    }

    public int getReachableDistance() {
        return this.mReachableDistance;
    }

    public double[] getSlopeCostList() {
        return this.mSlopeCostList;
    }

    public double[] getSpeedCostList() {
        return this.mSpeedCostList;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public int getTopSpeed() {
        return this.mTopSpeed;
    }

    public double[] getTransCostList() {
        return this.mTransCostList;
    }

    public int getWeight() {
        return this.mWeight;
    }

    public boolean isCharging() {
        return this.mIsCharging;
    }

    public void setAuxCost(double d) {
        this.mAuxCost = d;
    }

    public void setCharging(boolean z) {
        this.mIsCharging = z;
    }

    public void setCurveCostList(double[] dArr) {
        this.mCurveCostList = dArr;
    }

    public void setDriveMode(int i) {
        this.mDriveMode = i;
    }

    public void setEnergyUnit(int i) {
        this.mEnergyUnit = i;
    }

    public void setFerryRateCost(double d) {
        this.mFerryRateCost = d;
    }

    public void setHvBattEnergy(double d) {
        this.mHvBattEnergy = d;
    }

    public void setIsCharging(boolean z) {
        this.mIsCharging = z;
    }

    public void setLowEnergyAlert(int i) {
        this.mLowEnergyAlert = i;
    }

    public void setMaxBatteryEnergy(double d) {
        this.mMaxBatteryEnergy = d;
    }

    public void setPercentOfResidualEnergy(double d) {
        this.mPercentOfResidualEnergy = d;
    }

    public void setPowerInfoExtensionData(PowerInfoExtensionData powerInfoExtensionData) {
        this.powerInfoExtensionData = powerInfoExtensionData;
    }

    public void setPowertrainLoss(List<PowertrainLoss> list) {
        this.powertrainLoss = list;
    }

    public void setReachableDistance(int i) {
        this.mReachableDistance = i;
    }

    public void setSlopeCostList(double[] dArr) {
        this.mSlopeCostList = dArr;
    }

    public void setSpeedCostList(double[] dArr) {
        this.mSpeedCostList = dArr;
    }

    public void setTimestamp(long j) {
        this.mTimestamp = j;
    }

    public void setTopSpeed(int i) {
        this.mTopSpeed = i;
    }

    public void setTransCostList(double[] dArr) {
        this.mTransCostList = dArr;
    }

    public void setWeight(int i) {
        this.mWeight = i;
    }

    public String toString() {
        return "PowerInfoData{mTimestamp=" + this.mTimestamp + ", mHvBattEnergy=" + this.mHvBattEnergy + ", mLowEnergyAlert=" + this.mLowEnergyAlert + ", mReachableDistance=" + this.mReachableDistance + ", mIsCharging=" + this.mIsCharging + ", mDriveMode=" + this.mDriveMode + ", mEnergyUnit=" + this.mEnergyUnit + ", mTopSpeed=" + this.mTopSpeed + ", mWeight=" + this.mWeight + ", mSlopeCostList=" + Arrays.toString(this.mSlopeCostList) + ", mSpeedCostList=" + Arrays.toString(this.mSpeedCostList) + ", mTransCostList=" + Arrays.toString(this.mTransCostList) + ", mCurveCostList=" + Arrays.toString(this.mCurveCostList) + ", mAuxCost=" + this.mAuxCost + ", mFerryRateCost=" + this.mFerryRateCost + ", mMaxBatteryEnergy=" + this.mMaxBatteryEnergy + ", mPercentOfResidualEnergy=" + this.mPercentOfResidualEnergy + ", powertrainLoss=" + this.powertrainLoss + '}';
    }

    public PowerInfoData(double d, int i, int i2, boolean z, int i3, int i4, int i5, int i6, double[] dArr, double[] dArr2, double[] dArr3, double[] dArr4, double d2, double d3, double d4, double d5) {
        this.mHvBattEnergy = d;
        this.mLowEnergyAlert = i;
        this.mReachableDistance = i2;
        this.mIsCharging = z;
        this.mDriveMode = i3;
        this.mEnergyUnit = i4;
        this.mTopSpeed = i5;
        this.mWeight = i6;
        this.mSlopeCostList = dArr;
        this.mSpeedCostList = dArr2;
        this.mTransCostList = dArr3;
        this.mCurveCostList = dArr4;
        this.mAuxCost = d2;
        this.mFerryRateCost = d3;
        this.mMaxBatteryEnergy = d4;
        this.mPercentOfResidualEnergy = d5;
        this.mTimestamp = System.currentTimeMillis();
    }

    public PowerInfoData(PowerInfoData powerInfoData) {
        this.mHvBattEnergy = powerInfoData.mHvBattEnergy;
        this.mLowEnergyAlert = powerInfoData.mLowEnergyAlert;
        this.mReachableDistance = powerInfoData.mReachableDistance;
        this.mIsCharging = powerInfoData.mIsCharging;
        this.mDriveMode = powerInfoData.mDriveMode;
        this.mEnergyUnit = powerInfoData.mEnergyUnit;
        this.mTopSpeed = powerInfoData.mTopSpeed;
        this.mWeight = powerInfoData.mWeight;
        this.mSlopeCostList = powerInfoData.mSlopeCostList;
        this.mSpeedCostList = powerInfoData.mSpeedCostList;
        this.mTransCostList = powerInfoData.mTransCostList;
        this.mCurveCostList = powerInfoData.mCurveCostList;
        this.mAuxCost = powerInfoData.mAuxCost;
        this.mFerryRateCost = powerInfoData.mFerryRateCost;
        this.mMaxBatteryEnergy = powerInfoData.mMaxBatteryEnergy;
        this.mPercentOfResidualEnergy = powerInfoData.mPercentOfResidualEnergy;
        this.mTimestamp = System.currentTimeMillis();
    }
}
