package com.autonavi.amapauto.jni.protocol.data;

import defpackage.aa0;
import defpackage.jp;
import java.util.Arrays;

/* loaded from: classes.dex */
public class PowerPredictionSysData {
    public static final String TAG = "PowerPredictionSysData";
    public long callContext;
    public int chargingMode;
    public long clientID;
    public int[] slotDuration;
    public int[] slotPower;
    public byte[] slotTemperature;
    public byte startSoC;

    public static void jniNavTargetSocData(int[] iArr) {
        aa0.a(TAG, "jniNavTargetSocData:{?}", iArr);
        jp.I().a(iArr);
    }

    public static void jniPowerPredictionSysData(PowerPredictionSysData powerPredictionSysData) {
        aa0.a(TAG, "jniPowerPredictionSysData:{?}", powerPredictionSysData);
        jp.I().a(powerPredictionSysData);
    }

    public String toString() {
        return "PowerPredictionSysData{clientID=" + this.clientID + ", callContext=" + this.callContext + ", startSoC=" + ((int) this.startSoC) + ", chargingMode=" + this.chargingMode + ", slotDuration=" + Arrays.toString(this.slotDuration) + ", slotPower=" + Arrays.toString(this.slotPower) + ", slotTemperature=" + Arrays.toString(this.slotTemperature) + '}';
    }
}
