package com.autonavi.amapauto.jni.protocol.data;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class RouteInfoData extends ALResponeData {
    public int distance;
    public String labelText;
    public int oddNum;
    public ArrayList<RouteViaCityInfo> protocolCityInfos;
    public int routePreference;
    public List<String> streetNames;
    public long time;
    public List<TmcInfoData> tmcinfos;
    public int tolls;
    public String totalOddDistance;
    public int trafficLights;
    public int viaPOIdistance;
    public int viaPOItime;
    public String totalTimeDes = "";
    public String totalDistanceDes = "";

    public ArrayList<RouteViaCityInfo> getRouteViaCityInfos() {
        return this.protocolCityInfos;
    }

    public List<String> getStreetNames() {
        return this.streetNames;
    }

    public String getTmcInfosJson() {
        JSONArray jSONArray;
        JSONArray jSONArray2 = new JSONArray();
        try {
            jSONArray = new JSONArray();
            try {
                int tmcSize = getTmcSize();
                for (int i = 0; i < tmcSize; i++) {
                    JSONObject jSONObject = new JSONObject();
                    TmcInfoData tmcInfoData = this.tmcinfos.get(i);
                    jSONObject.put("status", tmcInfoData.status);
                    jSONObject.put("segmentIndex", tmcInfoData.number + 1);
                    jSONObject.put("percent", tmcInfoData.percent);
                    jSONArray.put(jSONObject);
                }
            } catch (Exception unused) {
                jSONArray2 = jSONArray;
                jSONArray = jSONArray2;
                return jSONArray.toString();
            }
        } catch (Exception unused2) {
        }
        return jSONArray.toString();
    }

    public int getTmcSize() {
        List<TmcInfoData> list = this.tmcinfos;
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public List<TmcInfoData> getTmcinfos() {
        return this.tmcinfos;
    }

    public void setRouteViaCityInfos(ArrayList<RouteViaCityInfo> arrayList) {
        this.protocolCityInfos = arrayList;
    }
}
