package com.autonavi.amapauto.jni.protocol.data;

import androidx.annotation.Keep;
import java.util.ArrayList;

@Keep
/* loaded from: classes.dex */
public class RouteLinkInfo {
    public ArrayList<NzpGeoPoint> geoPointArrayList;
    public ArrayList<PassingPointItem> passingPointArrayList;
    public int laneNum = 0;
    public int length = 0;
    public int level = 0;
    public long linkId = 0;
    public boolean mainRoadSeparated = false;
    public String roadName = "";
    public boolean sideRoad = false;
    public int speedLimit = 0;
    public int turnKind = 0;
    public boolean viaduct = false;
    public boolean wayPoint = false;
    public int formWay = 0;

    public int getFormWay() {
        return this.formWay;
    }

    public ArrayList<NzpGeoPoint> getGeoPointArrayList() {
        return this.geoPointArrayList;
    }

    public int getLaneNum() {
        return this.laneNum;
    }

    public int getLength() {
        return this.length;
    }

    public int getLevel() {
        return this.level;
    }

    public long getLinkId() {
        return this.linkId;
    }

    public boolean getMainRoadSeparated() {
        return this.mainRoadSeparated;
    }

    public ArrayList<PassingPointItem> getPassingPointArrayList() {
        return this.passingPointArrayList;
    }

    public String getRoadName() {
        String str = this.roadName;
        return str == null ? "" : str;
    }

    public boolean getSideRoad() {
        return this.sideRoad;
    }

    public int getSpeedLimit() {
        return this.speedLimit;
    }

    public int getTurnKind() {
        return this.turnKind;
    }

    public boolean getViaduct() {
        return this.viaduct;
    }

    public boolean getWayPoint() {
        return this.wayPoint;
    }

    public void setFormWay(int i) {
        this.formWay = i;
    }

    public void setGeoPointArrayList(ArrayList<NzpGeoPoint> arrayList) {
        this.geoPointArrayList = arrayList;
    }

    public void setLaneNum(int i) {
        this.laneNum = i;
    }

    public void setLength(int i) {
        this.length = i;
    }

    public void setLevel(int i) {
        this.level = i;
    }

    public void setLinkId(long j) {
        this.linkId = j;
    }

    public void setMainRoadSeparated(boolean z) {
        this.mainRoadSeparated = z;
    }

    public void setPassingPointArrayList(ArrayList<PassingPointItem> arrayList) {
        this.passingPointArrayList = arrayList;
    }

    public void setRoadName(String str) {
        this.roadName = str;
    }

    public void setSideRoad(boolean z) {
        this.sideRoad = z;
    }

    public void setSpeedLimit(int i) {
        this.speedLimit = i;
    }

    public void setTurnKind(int i) {
        this.turnKind = i;
    }

    public void setViaduct(boolean z) {
        this.viaduct = z;
    }

    public void setWayPoint(boolean z) {
        this.wayPoint = z;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("geoPointArrayList");
        sb.append(": ");
        ArrayList<NzpGeoPoint> arrayList = this.geoPointArrayList;
        sb.append(arrayList != null ? arrayList.toString() : "null");
        sb.append("\n");
        sb.append("laneNum");
        sb.append(": ");
        sb.append(this.laneNum);
        sb.append("\n");
        sb.append("length");
        sb.append(": ");
        sb.append(this.length);
        sb.append("\n");
        sb.append("level");
        sb.append(": ");
        sb.append(this.level);
        sb.append("\n");
        sb.append("linkId");
        sb.append(": ");
        sb.append(this.linkId);
        sb.append("\n");
        sb.append("mainRoadSeparated");
        sb.append(": ");
        sb.append(this.mainRoadSeparated);
        sb.append("\n");
        sb.append("passingPointArrayList");
        sb.append(": ");
        ArrayList<PassingPointItem> arrayList2 = this.passingPointArrayList;
        sb.append(arrayList2 != null ? arrayList2.toString() : "null");
        sb.append("\n");
        sb.append("roadName");
        sb.append(": ");
        sb.append(this.roadName);
        sb.append("\n");
        sb.append("sideRoad");
        sb.append(": ");
        sb.append(this.sideRoad);
        sb.append("\n");
        sb.append("speedLimit");
        sb.append(": ");
        sb.append(this.speedLimit);
        sb.append("\n");
        sb.append("turnKind");
        sb.append(": ");
        sb.append(this.turnKind);
        sb.append("\n");
        sb.append("viaduct");
        sb.append(": ");
        sb.append(this.viaduct);
        sb.append("\n");
        sb.append("wayPoint");
        sb.append(": ");
        sb.append(this.wayPoint);
        sb.append("\n");
        sb.append("formWay");
        sb.append(": ");
        sb.append(this.formWay);
        sb.append("\n");
        return sb.toString();
    }
}
