package com.autonavi.amapauto.jni.protocol.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RouteLinkInfo_JsonLubeParser implements Serializable {
    public static RouteLinkInfo parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RouteLinkInfo routeLinkInfo = new RouteLinkInfo();
        routeLinkInfo.setRoadName(jSONObject.optString("roadName", routeLinkInfo.getRoadName()));
        JSONArray optJSONArray = jSONObject.optJSONArray("geoPointList");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<NzpGeoPoint> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(NzpGeoPoint_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            routeLinkInfo.setGeoPointArrayList(arrayList);
        }
        routeLinkInfo.setLaneNum(jSONObject.optInt("laneNum", routeLinkInfo.getLaneNum()));
        routeLinkInfo.setLength(jSONObject.optInt("length", routeLinkInfo.getLength()));
        routeLinkInfo.setLevel(jSONObject.optInt("level", routeLinkInfo.getLevel()));
        routeLinkInfo.setLinkId(jSONObject.optLong("linkId", routeLinkInfo.getLinkId()));
        routeLinkInfo.setMainRoadSeparated(jSONObject.optBoolean("mainRoadSeparated", routeLinkInfo.getMainRoadSeparated()));
        JSONArray optJSONArray2 = jSONObject.optJSONArray("passingPointList");
        if (optJSONArray2 != null) {
            int length2 = optJSONArray2.length();
            ArrayList<PassingPointItem> arrayList2 = new ArrayList<>(length2);
            for (int i2 = 0; i2 < length2; i2++) {
                arrayList2.add(PassingPointItem_JsonLubeParser.parse(optJSONArray2.optJSONObject(i2)));
            }
            routeLinkInfo.setPassingPointArrayList(arrayList2);
        }
        routeLinkInfo.setSideRoad(jSONObject.optBoolean("sideRoad", routeLinkInfo.getSideRoad()));
        routeLinkInfo.setSpeedLimit(jSONObject.optInt("speedLimit", routeLinkInfo.getSpeedLimit()));
        routeLinkInfo.setTurnKind(jSONObject.optInt("turnKind", routeLinkInfo.getTurnKind()));
        routeLinkInfo.setViaduct(jSONObject.optBoolean("viaduct", routeLinkInfo.getViaduct()));
        routeLinkInfo.setWayPoint(jSONObject.optBoolean("wayPoint", routeLinkInfo.getWayPoint()));
        routeLinkInfo.setFormWay(jSONObject.optInt("formWay", routeLinkInfo.getFormWay()));
        return routeLinkInfo;
    }
}
