package com.autonavi.amapauto.jni.protocol.data;

import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RouteLinkInfo_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RouteLinkInfo routeLinkInfo) throws JSONException {
        if (routeLinkInfo == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        if (routeLinkInfo.getGeoPointArrayList() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<NzpGeoPoint> it = routeLinkInfo.getGeoPointArrayList().iterator();
            while (it.hasNext()) {
                NzpGeoPoint next = it.next();
                if (next != null) {
                    jSONArray.put(NzpGeoPoint_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("geoPointList", jSONArray);
        }
        jSONObject.put("laneNum", routeLinkInfo.getLaneNum());
        jSONObject.put("length", routeLinkInfo.getLength());
        jSONObject.put("level", routeLinkInfo.getLevel());
        jSONObject.put("linkId", routeLinkInfo.getLinkId());
        jSONObject.put("mainRoadSeparated", routeLinkInfo.getMainRoadSeparated());
        if (routeLinkInfo.getPassingPointArrayList() != null) {
            JSONArray jSONArray2 = new JSONArray();
            Iterator<PassingPointItem> it2 = routeLinkInfo.getPassingPointArrayList().iterator();
            while (it2.hasNext()) {
                PassingPointItem next2 = it2.next();
                if (next2 != null) {
                    jSONArray2.put(PassingPointItem_JsonLubeSerializer.serialize(next2));
                }
            }
            jSONObject.put("passingPointList", jSONArray2);
        }
        jSONObject.put("roadName", routeLinkInfo.getRoadName());
        jSONObject.put("sideRoad", routeLinkInfo.getSideRoad());
        jSONObject.put("speedLimit", routeLinkInfo.getSpeedLimit());
        jSONObject.put("turnKind", routeLinkInfo.getTurnKind());
        jSONObject.put("viaduct", routeLinkInfo.getViaduct());
        jSONObject.put("wayPoint", routeLinkInfo.getWayPoint());
        jSONObject.put("formWay", routeLinkInfo.getFormWay());
        return jSONObject;
    }
}
