package com.autonavi.amapauto.location.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.autonavi.amapauto.common.Coord3DDouble;

/* loaded from: classes.dex */
public class LocMapMatchedCandidate implements Parcelable {
    public static final Parcelable.Creator<LocMapMatchedCandidate> CREATOR = new a();
    public int lengthAlongLink;
    public LocLinkReference linkReference;
    public Coord3DDouble position;
    public boolean positiveLinkDirection;
    public float probability;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<LocMapMatchedCandidate> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public LocMapMatchedCandidate createFromParcel(Parcel parcel) {
            return new LocMapMatchedCandidate(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public LocMapMatchedCandidate[] newArray(int i) {
            return new LocMapMatchedCandidate[i];
        }
    }

    public LocMapMatchedCandidate() {
    }

    @Override // android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getLengthAlongLink() {
        return this.lengthAlongLink;
    }

    public LocLinkReference getLinkReference() {
        return this.linkReference;
    }

    public Coord3DDouble getPosition() {
        return this.position;
    }

    public float getProbability() {
        return this.probability;
    }

    public boolean isPositiveLinkDirection() {
        return this.positiveLinkDirection;
    }

    public void setLengthAlongLink(int i) {
        this.lengthAlongLink = i;
    }

    public void setLinkReference(LocLinkReference locLinkReference) {
        this.linkReference = locLinkReference;
    }

    public void setPosition(Coord3DDouble coord3DDouble) {
        this.position = coord3DDouble;
    }

    public void setPositiveLinkDirection(boolean z) {
        this.positiveLinkDirection = z;
    }

    public void setProbability(float f) {
        this.probability = f;
    }

    @Override // android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeFloat(this.probability);
        parcel.writeByte(this.positiveLinkDirection ? (byte) 1 : (byte) 0);
        parcel.writeInt(this.lengthAlongLink);
    }

    public LocMapMatchedCandidate(Parcel parcel) {
        this.probability = parcel.readByte();
        this.positiveLinkDirection = parcel.readByte() != 0;
        this.lengthAlongLink = parcel.readInt();
    }
}
