package com.autonavi.amapauto.location.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.autonavi.amapauto.common.Coord3DDouble;
import java.util.List;

/* loaded from: classes.dex */
public class LocMapMatchedResult implements Parcelable {
    public static final Parcelable.Creator<LocMapMatchedResult> CREATOR = new a();
    public List<LocMapMatchedCandidate> candidates;
    public int contentVersion;
    public Coord3DDouble drPosition;
    public boolean hasRoute;
    public int matchedRouteId;

    @Deprecated
    public Coord3DDouble mmPosition;
    public boolean onroad;
    public int regionId;
    public float speed3D;
    public long timestamp;
    public long utc;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<LocMapMatchedResult> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public LocMapMatchedResult createFromParcel(Parcel parcel) {
            return new LocMapMatchedResult(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public LocMapMatchedResult[] newArray(int i) {
            return new LocMapMatchedResult[i];
        }
    }

    public LocMapMatchedResult() {
    }

    @Override // android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public List<LocMapMatchedCandidate> getCandidates() {
        return this.candidates;
    }

    public int getContentVersion() {
        return this.contentVersion;
    }

    public Coord3DDouble getDrPosition() {
        return this.drPosition;
    }

    public int getMatchedRouteId() {
        return this.matchedRouteId;
    }

    @Deprecated
    public Coord3DDouble getMmPosition() {
        return this.mmPosition;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public float getSpeed3D() {
        return this.speed3D;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getUtc() {
        return this.utc;
    }

    public boolean isHasRoute() {
        return this.hasRoute;
    }

    public boolean isOnroad() {
        return this.onroad;
    }

    public void setCandidates(List<LocMapMatchedCandidate> list) {
        this.candidates = list;
    }

    public void setContentVersion(int i) {
        this.contentVersion = i;
    }

    public void setDrPosition(Coord3DDouble coord3DDouble) {
        this.drPosition = coord3DDouble;
    }

    public void setHasRoute(boolean z) {
        this.hasRoute = z;
    }

    public void setMatchedRouteId(int i) {
        this.matchedRouteId = i;
    }

    @Deprecated
    public void setMmPosition(Coord3DDouble coord3DDouble) {
        this.mmPosition = coord3DDouble;
    }

    public void setOnroad(boolean z) {
        this.onroad = z;
    }

    public void setRegionId(int i) {
        this.regionId = i;
    }

    public void setSpeed3D(float f) {
        this.speed3D = f;
    }

    public void setTimestamp(long j) {
        this.timestamp = j;
    }

    public void setUtc(long j) {
        this.utc = j;
    }

    public String toString() {
        return "LocMapMatchedResult{timestamp=" + this.timestamp + ", onroad=" + this.onroad + ", candidates=" + this.candidates + ", drPosition=" + this.drPosition + ", utc=" + this.utc + ", speed3D=" + this.speed3D + ", matchedRouteId=" + this.matchedRouteId + ", contentVersion=" + this.contentVersion + ", regionId=" + this.regionId + ", hasRoute=" + this.hasRoute + '}';
    }

    @Override // android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeLong(this.timestamp);
        parcel.writeByte(this.onroad ? (byte) 1 : (byte) 0);
        parcel.writeLong(this.utc);
        parcel.writeFloat(this.speed3D);
        parcel.writeInt(this.matchedRouteId);
        parcel.writeInt(this.contentVersion);
        parcel.writeInt(this.regionId);
        parcel.writeByte(this.hasRoute ? (byte) 1 : (byte) 0);
    }

    public LocMapMatchedResult(Parcel parcel) {
        this.timestamp = parcel.readLong();
        this.onroad = parcel.readByte() != 0;
        this.utc = parcel.readLong();
        this.speed3D = parcel.readFloat();
        this.matchedRouteId = parcel.readInt();
        this.contentVersion = parcel.readInt();
        this.regionId = parcel.readInt();
        this.hasRoute = parcel.readByte() != 0;
    }
}
