package com.autonavi.amapauto.memory;

import android.app.ActivityManager;
import android.os.Build;
import android.os.Process;
import androidx.annotation.Keep;
import defpackage.aa0;
import defpackage.ee;

@Keep
/* loaded from: classes.dex */
public class AutoMemory {
    public static ProcessMemoryInfo getProcessMemoryInfo() {
        ProcessMemoryInfo processMemoryInfo = new ProcessMemoryInfo();
        try {
            int myPid = Process.myPid();
            ActivityManager activityManager = (ActivityManager) ee.A().f().getSystemService("activity");
            if (activityManager != null) {
                processMemoryInfo.totalPrivateDirty = activityManager.getProcessMemoryInfo(new int[]{myPid})[0].getTotalPss();
            } else {
                processMemoryInfo.totalPrivateDirty = 0;
            }
        } catch (Exception e) {
            aa0.a("AutoMemory", "getProcessMemeryInfo Exception:", e, new Object[0]);
        }
        return processMemoryInfo;
    }

    public static SystemMemoryInfo getSystemMemoryInfo() {
        SystemMemoryInfo systemMemoryInfo = new SystemMemoryInfo();
        ActivityManager activityManager = (ActivityManager) ee.A().f().getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        if (activityManager != null) {
            activityManager.getMemoryInfo(memoryInfo);
            if (Build.VERSION.SDK_INT >= 16) {
                systemMemoryInfo.totalSize = memoryInfo.totalMem;
            } else {
                systemMemoryInfo.totalSize = 0L;
            }
            systemMemoryInfo.availSize = memoryInfo.availMem;
            systemMemoryInfo.lowThresholdSize = memoryInfo.threshold;
        }
        return systemMemoryInfo;
    }
}
