package com.autonavi.amapauto.protocol.constant;

import androidx.annotation.Keep;
import defpackage.m60;
import defpackage.n60;

@Keep
/* loaded from: classes.dex */
public class StandardProtocolKey {

    @m60(baseType = "float")
    public static final String ACCURACY = "accuracy";

    @m60(baseType = "boolean")
    public static final String ACC_IS_ON = "acc_is_on";

    @m60(baseType = "String")
    public static final String ADDRESS = "ADDRESS";

    @m60(baseType = "String")
    public static final String ALONG_POI_ADDR = "poi_addr";

    @m60(baseType = "int")
    public static final String ALONG_POI_DISTANCE = "poi_distance";
    public static final String ALONG_POI_INFO = "poi_info";

    @m60(baseType = "String")
    public static final String ALONG_POI_LATITUDE = "poi_Latitude";

    @m60(baseType = "String")
    public static final String ALONG_POI_LONGITUDE = "poi_Longitude";

    @m60(baseType = "String")
    public static final String ALONG_POI_NAME = "poi_name";

    @m60(baseType = "int")
    public static final String ALONG_SEARCH_RESULT_SIZE = "search_result_size";

    @m60(baseType = "int")
    public static final String ALONG_SEARCH_TYPE = "search_type";

    @m60(baseType = "double")
    public static final String ALTITUDE = "altitude";

    @m60(baseType = "double")
    public static final String ARRIVE_POI_LATITUDE = "ArrivePoiLatitude";

    @m60(baseType = "double")
    public static final String ARRIVE_POI_LONGITUDE = "ArrivePoiLongitude";

    @m60(baseType = "int")
    public static final String ARRIVE_POI_TYPE = "ArrivePoiType";

    @m60(baseType = "String")
    public static final String AUTONAVIMAP = "AUTONAVIMAP";

    @m60(baseType = "String")
    public static final String AUTOTRACEVIEW = "AUTOTRACEVIEW";

    @m60(baseType = "float")
    public static final String BEARING = "bearing";

    @m60(baseType = "int")
    @n60({"protocolId=13005,baseType=int,isMustFill=false,maxValue=4,minValue=3,intValues={3,4}"})
    public static final String CARD_TYPE = "CARD_TYPE";

    @m60(baseType = "int")
    public static final String CATEGORY = "CATEGORY";

    @m60(baseType = "String")
    public static final String CHANNEL_NUM = "CHANNEL_NUM";

    @m60(baseType = "String")
    public static final String CITY_SUGGESTION_NAME = "city_suggestion_name";

    @m60(baseType = "int")
    public static final String CITY_SUGGESTION_NUM = "city_suggestion_num";

    @m60(baseType = "String")
    public static final String DATA_VERSION = "DATA_VERSION";

    @m60(baseType = "int")
    @n60({"protocolId=13005,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10040,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String DEST = "DEST";

    @m60(baseType = "int")
    @n60({"protocolId=10037,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10038,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10039,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10058,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String DEV = "DEV";

    @m60(baseType = "int")
    public static final String DIALOG_ID = "DIALOG_ID";

    @m60(baseType = "String")
    public static final String DIALOG_LEFT = "DIALOG_LEFT";

    @m60(baseType = "String")
    public static final String DIALOG_MIDDLE = "DIALOG_MIDDLE";

    @m60(baseType = "String")
    public static final String DIALOG_MSG = "DIALOG_MSG";

    @m60(baseType = "String")
    public static final String DIALOG_RIGHT = "DIALOG_RIGHT";

    @m60(baseType = "String")
    public static final String DIALOG_TITILE = "DIALOG_TITILE";

    @m60(baseType = "int")
    public static final String DISTANCE = "DISTANCE";

    @m60(baseType = "String")
    public static final String DISTANCE_AUTO = "distance_AUTO";

    @m60(baseType = "int")
    public static final String DITANCE = "ditance";

    @m60(baseType = "int")
    public static final String ENGINE_ID = "ENGINE_ID";

    @m60(baseType = "double")
    public static final String ENTRY_LAT = "ENTRY_LAT";

    @m60(baseType = "double")
    public static final String ENTRY_LATITUDE = "entry_latitude";

    @m60(baseType = "double")
    public static final String ENTRY_LON = "ENTRY_LON";

    @m60(baseType = "double")
    public static final String ENTRY_LONGITUDE = "entry_longitude";
    public static final int EVENT_TOUCH_FRAGMENT_NAVI_PARKING_DIALOG = 2;
    public static final int EVENT_TOUCH_FRAGMENT_NAVI_PREFER_ROUTE = 3;
    public static final int EVENT_TOUCH_FRAGMENT_ROUTECARRESULT = 0;
    public static final int EVENT_TOUCH_FRAGMENT_SEARCHRESULT = 1;
    public static final int EVENT_TOUCH_FRAGMENT_TRAFFIC_REPORT = 4;

    @m60(baseType = "String")
    public static final String EXIT_INFO_DIRECTION = "EXIT_INFO_DIRECTION";

    @m60(baseType = "long")
    public static final String EXIT_INFO_DISTANCE = "EXIT_INFO_DISTANCE";

    @m60(baseType = "int")
    public static final String EXIT_INFO_EXIT_NAME_NUM = "EXIT_INFO_EXIT_NAME_NUM";

    @m60(baseType = "int")
    public static final String EXIT_INFO_RESULT_STATE = "EXIT_INFO_RESULT_STATE";

    @m60(baseType = "long")
    public static final String EXIT_INFO_TIME = "EXIT_INFO_TIME";

    @m60(baseType = "int")
    @n60({"protocolId=12011,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXIT_INFO_TYPE = "EXIT_INFO_TYPE";

    @m60(baseType = "String")
    @n60({"protocolId = 60040,baseType = String", "protocolId = 60041,baseType = String"})
    public static final String EXTRA_ACCOUNTID = "accountID";

    @m60(baseType = "int")
    @n60({"protocolId = 60040,baseType = int", "protocolId = 60041,baseType = int"})
    public static final String EXTRA_ACCOUNTROLE = "accountRole";

    @m60(baseType = "int")
    @n60({"protocolId = 60037,baseType = int"})
    public static final String EXTRA_ACTIONTYPE = "actionType";

    @m60(baseType = "String")
    @n60({"protocolId = 60034,baseType = String"})
    public static final String EXTRA_ACTIVATEPATH = "activatePath";

    @m60(baseType = "int")
    public static final String EXTRA_ACTIVATE_STATE = "EXTRA_ACTIVATE_STATE";

    @m60(baseType = "boolean")
    public static final String EXTRA_ADAS_SPEEDLIMIT_STATE = "EXTRA_ADAS_SPEEDLIMIT_STATE";

    @m60(baseType = "String")
    public static final String EXTRA_ADDRESS = "EXTRA_ADDRESS";

    @m60(baseType = "String")
    @n60({"protocolId=12116,baseType=String"})
    public static final String EXTRA_APK_NAME = "apkName";

    @m60(baseType = "String")
    public static final String EXTRA_AREA_CODE = "AREA_CODE";

    @m60(baseType = "String")
    public static final String EXTRA_AREA_NAME = "AREA_NAME";

    @m60(baseType = "String")
    @n60({"protocolId = 60034,baseType = String"})
    public static final String EXTRA_AUDIOPATH = "audioPath";

    @m60(baseType = "int")
    @n60({"protocolId = 60072,baseType = int"})
    public static final String EXTRA_AUTHORIZATIONSTATUS = "authorizationStatus";

    @m60(baseType = "boolean")
    public static final String EXTRA_AUTO_BACK_NAVI_DATA = "EXTRA_AUTO_BACK_NAVI_DATA";

    @m60(baseType = "boolean")
    public static final String EXTRA_AUTO_CAN_ZOOM = "EXTRA_CAN_ZOOM";
    public static final String EXTRA_AUTO_HUD_STATE = "EXTRA_AUTO_HUD_STATE";

    @m60(baseType = "boolean")
    public static final String EXTRA_AUTO_IS_OPEN_NETWORK_LOCATION = "EXTRA_AUTO_IS_OPEN_NETWORK_LOCATION";

    @m60(baseType = "int")
    public static final String EXTRA_AUTO_LOGOUT_RESULT = "AUTO_LOGOUT_RESULT";

    @m60(baseType = "String")
    public static final String EXTRA_AUTO_USER_AVATAR = "AUTO_USER_AVATARD";

    @m60(baseType = "String")
    public static final String EXTRA_AUTO_USER_ID = "AUTO_USER_ID";

    @m60(baseType = "String")
    public static final String EXTRA_AUTO_USER_NAME = "AUTO_USER_NAME";

    @m60(baseType = "int")
    public static final String EXTRA_AUTO_ZOOM_TYPE = "EXTRA_ZOOM_TYPE";

    @m60(baseType = "boolean")
    public static final String EXTRA_AVOID_TRAFFIC_JAM_CONTROL = "EXTRA_AVOID_TRAFFIC_JAM_CONTROL";

    @m60(baseType = "String")
    public static final String EXTRA_AVOID_TRAFFIC_JAM_MESSAGE = "EXTRA_AVOID_TRAFFIC_JAM_MESSAGE";

    @m60(baseType = "boolean")
    public static final String EXTRA_BACK = "EXTRA_BACK";
    public static final String EXTRA_BATTERY_MILEAGE = "EXTRA_BATTERY_MILEAGE";
    public static final String EXTRA_BATTERY_PCT = "EXTRA_BATTERY_PCT";
    public static final String EXTRA_BATTERY_TYPE = "EXTRA_BATTERY_TYPE";
    public static final String EXTRA_BATTERY_WARNING_PCT = "EXTRA_BATTERY_WARNING_PCT";

    @m60(baseType = "int")
    @n60({"protocolId=10102,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_BINDING_ACK = "BINDING_ACK";

    @m60(baseType = "String")
    public static final String EXTRA_BINDING_ID = "BINDING_ID";
    public static final String EXTRA_CALCULATED_FAIL_OPTION_DATA = "EXTRA_CALCULATED_FAIL_OPTION_DATA";

    @m60(baseType = "String")
    @n60({"protocolId=12116,baseType=String,isMustFill=true"})
    public static final String EXTRA_CAMERA_CONNECT = "cameraConnect";

    @m60(baseType = "String")
    @n60({"protocolId=12116,baseType=String,isMustFill=true"})
    public static final String EXTRA_CAMERA_DISPLAY = "cameraDisplay";

    @m60(baseType = "String")
    @n60({"protocolId=12116,baseType=String,isMustFill=true"})
    public static final String EXTRA_CAMERA_NAME = "cameraName";
    public static final String EXTRA_CAMERA_REQUEST = "EXTRA_CAMERA_REQUEST";

    @m60(baseType = "int")
    @n60({"protocolId=12114,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_CAMERA_STATE = "EXTRA_CAMERA_STATE";

    @m60(baseType = "int")
    @n60({"protocolId = 60071,baseType = int"})
    public static final String EXTRA_CARAXES = "carAxes";

    @m60(baseType = "int")
    @n60({"protocolId = 60071,baseType = int"})
    public static final String EXTRA_CARHEIGHT = "carHeight";

    @m60(baseType = "int")
    @n60({"protocolId = 60071,baseType = int"})
    public static final String EXTRA_CARLENGTH = "carLength";

    @m60(baseType = "int")
    @n60({"protocolId = 60071,baseType = int"})
    public static final String EXTRA_CARLOADING = "carLoading";

    @m60(baseType = "String")
    @n60({"protocolId = 60071,baseType = String,isLonLat = true"})
    public static final String EXTRA_CARPLATENUMBER = "carPlateNumber";

    @m60(baseType = "int")
    @n60({"protocolId = 60071,baseType = int"})
    public static final String EXTRA_CARRATEDLOADING = "carRatedLoading";
    public static final String EXTRA_CARRESTRICTIONSSTATE = "carRestrictionsState";

    @m60(baseType = "int")
    @n60({"protocolId = 60071,baseType = int"})
    public static final String EXTRA_CARTYPE = "carType";

    @m60(baseType = "int")
    @n60({"protocolId = 60071,baseType = int"})
    public static final String EXTRA_CARWIDTH = "carWidth";

    @m60(baseType = "String")
    @n60({"protocolId=13027,baseType=String,isMustFill=true"})
    public static final String EXTRA_CAR_PLATE_NUMBER = "CAR_PLATE_NUMBER";

    @m60(baseType = "int")
    @n60({"protocolId=10047,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_CASUAL_MUTE = "EXTRA_CASUAL_MUTE";

    @m60(baseType = "double")
    public static final String EXTRA_CENTERLAT = "EXTRA_CENTERLAT";

    @m60(baseType = "double")
    public static final String EXTRA_CENTERLON = "EXTRA_CENTERLON";
    public static final String EXTRA_CHANGE_APP_RECT_BOTTOM = "EXTRA_CHANGE_APP_RECT_BOTTOM";
    public static final String EXTRA_CHANGE_APP_RECT_LEFT = "EXTRA_CHANGE_APP_RECT_LEFT";
    public static final String EXTRA_CHANGE_APP_RECT_RIGHT = "EXTRA_CHANGE_APP_RECT_RIGHT";
    public static final String EXTRA_CHANGE_APP_RECT_TOP = "EXTRA_CHANGE_APP_RECT_TOP";

    @m60(baseType = "int")
    @n60({"protocolId=10055,baseType=int,isMustFill=false,intValues={1,2,3}"})
    public static final String EXTRA_CHANGE_ROAD = "EXTRA_CHANGE_ROAD";
    public static final String EXTRA_CHANNELID = "channelID";

    @m60(baseType = "int")
    public static final String EXTRA_CHOICE = "EXTRA_CHOICE";

    @m60(baseType = "String")
    public static final String EXTRA_CITY = "CITY_NAME";

    @m60(baseType = "String")
    @n60({"protocolId = 60058,baseType = String"})
    public static final String EXTRA_CITYNAME = "cityName";

    @m60(baseType = "String")
    public static final String EXTRA_CITY_NAME = "cityName";
    public static final String EXTRA_CLEAR_HISTORY_RESULT_CODE = "EXTRA_CLEAR_HISTORY_RESULT_CODE";

    @m60(baseType = "boolean")
    public static final String EXTRA_CLEAR_HISTORY_STATE = "EXTRA_CLEAR_HISTORY_STATE";
    public static final String EXTRA_COMMON = "common";

    @m60(baseType = "boolean")
    @n60({"protocolId = 60033,baseType = boolean"})
    public static final String EXTRA_COMMUTINGSTATUS = "commutingStatus";

    @m60(baseType = "String")
    public static final String EXTRA_CONTEXT = "EXTRA_CONTEXT";

    @m60(baseType = "int")
    public static final String EXTRA_CONTROL = "EXTRA_CONTROL";

    @m60(baseType = "String")
    public static final String EXTRA_COUNTRY_NAME = "COUNTRY_NAME";
    public static final String EXTRA_CROSS = "EXTRA_CROSS";

    @m60(baseType = "int")
    public static final String EXTRA_CROSS_MAP = "EXTRA_CROSS_MAP";
    public static final String EXTRA_CRUISE_TTS_DATA = "EXTRA_TTS_DATA";

    @m60(baseType = "int")
    @n60({"protocolId=12112,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_CRUISE_TYPE = "EXTRA_CRUISE_TYPE";
    public static final String EXTRA_CURRENT_STATE = "EXTRA_CURRENT_STATE";
    public static final String EXTRA_CURRENT_THEME = "EXTRA_CURRENT_THEME";
    public static final String EXTRA_CURROADNAME = "curRoadName";
    public static final String EXTRA_DATE = "EXTRA_DATE";

    @m60(baseType = "int")
    @n60({"protocolId=10048,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_DAY_NIGHT_MODE = "EXTRA_DAY_NIGHT_MODE";

    @m60(baseType = "int")
    @n60({"protocolId=10012,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10013,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10032,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10007,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10076,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10023,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10024,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_DEV = "EXTRA_DEV";

    @m60(baseType = "String")
    public static final String EXTRA_DEVICE_ID = "EXTRA_DEVICE_ID";
    public static final String EXTRA_DIR = "dir";

    @m60(baseType = "int")
    @n60({"protocolId=60017,baseType=int,isMustFill=true,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_DIRECTION_X = "directionX";

    @m60(baseType = "int")
    @n60({"protocolId=60017,baseType=int,isMustFill=true,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_DIRECTION_Y = "directionY";

    @m60(baseType = "String")
    public static final String EXTRA_DISTRICT = "DISTRICT_NAME";

    @m60(baseType = "String")
    @n60({"protocolId = 60058,baseType = String"})
    public static final String EXTRA_DISTRICTNAME = "districtName";

    @m60(baseType = "String")
    public static final String EXTRA_DISTRICT_NAME = "districtName";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true", "protocolId=10007,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_DLAT = "EXTRA_DLAT";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true", "protocolId=10007,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_DLON = "EXTRA_DLON";

    @m60(baseType = "String")
    @n60({"protocolId=10076,baseType=String,isMustFill=true", "protocolId=10007,baseType=String,isMustFill=true"})
    public static final String EXTRA_DNAME = "EXTRA_DNAME";

    @m60(baseType = "String")
    public static final String EXTRA_DRIVE_WAY = "EXTRA_DRIVE_WAY";

    @m60(baseType = "int")
    @n60({"protocolId=60017,baseType=int,isMustFill=true"})
    public static final String EXTRA_DURATION = "duration";

    @m60(baseType = "String")
    public static final String EXTRA_D_POI_ID = "EXTRA_D_POI_ID";

    @m60(baseType = "boolean")
    public static final String EXTRA_ENDURANCE_DATA = "EXTRA_ENDURANCE_DATA";
    public static final String EXTRA_ENDURANCE_DESTINATION = "EXTRA_ENDURANCE_DESTINATION";

    @m60(baseType = "double")
    @n60({"protocolId = 60058,baseType = double"})
    public static final String EXTRA_ENTRYLATITUDE = "entryLatitude";

    @m60(baseType = "double")
    @n60({"protocolId = 60058,baseType = double"})
    public static final String EXTRA_ENTRYLONGITUDE = "entryLongitude";
    public static final String EXTRA_ESTI_DATA_CONSUMP = "estiDataConsump";

    @m60(baseType = "int")
    public static final String EXTRA_EVENT_TOUCH_FRAGMENT = "EXTRA_EVENT_TOUCH_FRAGMENT";

    @m60(baseType = "int")
    @n60({"protocolId=12112,baseType=int,isMustFill=false,maxValue=1,minValue=-1,intValues={-1,0,1}"})
    public static final String EXTRA_EXIT_AR = "exitAR";

    @m60(baseType = "String")
    public static final String EXTRA_EXTERNAL_ALC_INFO = "EXTRA_EXTERNAL_ALC_INFO";
    public static final String EXTRA_EXTERNAL_CONFIG_MODE = "EXTRA_EXTERNAL_CONFIG_MODE";

    @m60(baseType = "boolean")
    public static final String EXTRA_EXTERNAL_CROSS_CONTROL = "EXTRA_EXTERNAL_CROSS_CONTROL";

    @m60(baseType = "int")
    @n60({"protocolId=10106,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_EXTERNAL_CROSS_TYPE = "EXTRA_EXTERNAL_CROSS_TYPE";

    @n60({"protocolId=10120,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_EXTERNAL_DAY_NIGHT_MODE = "EXTRA_EXTERNAL_DAY_NIGHT_MODE";

    @m60(baseType = "boolean")
    public static final String EXTRA_EXTERNAL_DYNAMIC_LEVEL_LOCK = "EXTRA_EXTERNAL_DYNAMIC_LEVEL_LOCK";

    @m60(baseType = "int")
    public static final String EXTRA_EXTERNAL_ENGINE_ID = "EXTRA_EXTERNAL_ENGINE_ID";
    public static final String EXTRA_EXTERNAL_FULL_VIEW = "EXTRA_EXTERNAL_FULL_VIEW";
    public static final String EXTRA_EXTERNAL_MAPLEVEL_STATUS = "EXTRA_EXTERNAL_MAPLEVEL_STATUS";

    @m60(baseType = "int")
    @n60({"protocolId=10104,baseType=int,isMustFill=false,maxValue=17,minValue=0"})
    public static final String EXTRA_EXTERNAL_MAP_LEVEL = "EXTRA_EXTERNAL_MAP_LEVEL";

    @m60(baseType = "int")
    @n60({"protocolId=10104,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_EXTERNAL_MAP_MODE = "EXTRA_EXTERNAL_MAP_MODE";

    @m60(baseType = "int")
    @n60({"protocolId=10104,baseType=int,isMustFill=false,maxValue=3,minValue=1,intValues={1,2,3}"})
    public static final String EXTRA_EXTERNAL_MAP_POSITION = "EXTRA_EXTERNAL_MAP_POSITION";

    @m60(baseType = "int")
    public static final String EXTRA_EXTERNAL_MINI_MAP = "EXTRA_EXTERNAL_MINI_MAP";
    public static final String EXTRA_EXTERNAL_SCREEN_MODE = "EXTRA_EXTERNAL_SCREEN_MODE";
    public static final String EXTRA_FAVORITE = "EXTRA_FAVORITE";

    @m60(baseType = "String")
    public static final String EXTRA_FAVORITE_DATA = "EXTRA_FAVORITE_DATA";

    @m60(baseType = "String")
    public static final String EXTRA_FAVORITE_MY_LOCATION = "EXTRA_FAVORITE_MY_LOCATION";
    public static final String EXTRA_FINGER_COUNTS = "EXTRA_FINGER_COUNTS";

    @n60({"protocolId=60019,baseType=int,isMustFill=true,maxValue=3,minValue=0,intValues={0,1,2,3}"})
    public static final String EXTRA_FLEETIM_OPERATONTYPE = "operationType";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_FMIDLAT = "EXTRA_FMIDLAT";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_FMIDLON = "EXTRA_FMIDLON";

    @m60(baseType = "String")
    @n60({"protocolId=10076,baseType=String,isMustFill=true"})
    public static final String EXTRA_FMIDNAME = "EXTRA_FMIDNAME";

    @m60(baseType = "String")
    public static final String EXTRA_FMID_POI_ID = "EXTRA_FMID_POI_ID";
    public static final String EXTRA_FULL_SCREEN_STATUS = "EXTRA_FULL_SCREEN_STATUS";

    @m60(baseType = "int")
    @n60({"protocolId = 60054,baseType = int"})
    public static final String EXTRA_FUNCCONFIG_STATE = "state";

    @m60(baseType = "int")
    public static final String EXTRA_GEOLOCATION = "EXTRA_GEOLOCATION";

    @m60(baseType = "int")
    public static final String EXTRA_GUIDEINFO_OUTPUT = "EXTRA_GUIDEINFO_OUTPUT";

    @m60(baseType = "int")
    @n60({"protocolId=10017,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_HEADLIGHT_STATE = "EXTRA_HEADLIGHT_STATE";

    @m60(baseType = "String")
    public static final String EXTRA_HOME_AND_COMPANY = "EXTRA_HOME_AND_COMPANY";

    @m60(baseType = "String")
    public static final String EXTRA_HOME_OR_COMPANY_ETA = "EXTRA_HOME_OR_COMPANY_ETA";

    @m60(baseType = "boolean")
    public static final String EXTRA_HOME_OR_COMPANY_WHAT = "EXTRA_HOME_OR_COMPANY_WHAT";

    @m60(baseType = "String")
    @n60({"protocolId=12116,baseType=String,isMustFill=true"})
    public static final String EXTRA_IMU = "imu";

    @m60(baseType = "int")
    public static final String EXTRA_ISENTER = "EXTRA_ISENTER";

    @m60(baseType = "boolean")
    public static final String EXTRA_IS_BINDING_SUCCES = "IS_BINDING_SUCCES";

    @m60(baseType = "boolean")
    public static final String EXTRA_IS_FIRST_PAGE = "EXTRA_IS_FIRST_PAGE";

    @m60(baseType = "boolean")
    public static final String EXTRA_IS_LAST_PAGE = "EXTRA_IS_LAST_PAGE";

    @m60(baseType = "boolean")
    public static final String EXTRA_IS_LIST_BOTTOM = "EXTRA_IS_LIST_BOTTOM";

    @m60(baseType = "boolean")
    public static final String EXTRA_IS_LIST_TOP = "EXTRA_IS_LIST_TOP";

    @m60(baseType = "int")
    @n60({"protocolId=10006,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_IS_SHOW = "EXTRA_IS_SHOW";

    @m60(baseType = "String")
    @n60({"protocolId=10023,baseType=String,isMustFill=true", "protocolId=10024,baseType=String,isMustFill=true"})
    public static final String EXTRA_KEYWORD = "EXTRA_KEYWORD";

    @m60(baseType = "int")
    @n60({"protocolId = 60025,baseType = int"})
    public static final String EXTRA_LANE = "lane";

    @m60(baseType = "double")
    @n60({"protocolId = 60025,baseType = double"})
    public static final String EXTRA_LANEDISTANCEFUSION = "laneDistanceFusion";

    @m60(baseType = "int")
    @n60({"protocolId = 60025,baseType = int,isLonLat = true"})
    public static final String EXTRA_LANELINEVIOLATION = "laneLineViolation";

    @m60(baseType = "int")
    @n60({"protocolId = 60025,baseType = int"})
    public static final String EXTRA_LANEMARKERTYPE = "laneMarkerType";

    @m60(baseType = "double")
    @n60({"protocolId=10012,baseType=double,isMustFill=true,isLonLat=true", "protocolId=10013,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_LAT = "EXTRA_LAT";

    @m60(baseType = "double")
    @n60({"protocolId = 60058,baseType = double,isLonLat = true"})
    public static final String EXTRA_LATITUDE = "latitude";
    public static final String EXTRA_LATITUDE_VALUE = "EXTRA_LATITUDE_VALUE";
    public static final String EXTRA_LATLONG_TYPE = "EXTRA_LATLONG_TYPE";
    public static final String EXTRA_LAUNCH_AUTO = "EXTRA_LAUNCH_AUTO";

    @m60(baseType = "int")
    public static final String EXTRA_LINKTYPE = "EXTRA_LINKTYPE";

    @m60(baseType = "String")
    public static final String EXTRA_LOCATION_INFO = "EXTRA_LOCATION_INFO";

    @m60(baseType = "String")
    public static final String EXTRA_LOCATION_TRAFFIC_INFO = "EXTRA_LOCATION_TRAFFIC_INFO";

    @m60(baseType = "String")
    @n60({"protocolId = 60034,baseType = String"})
    public static final String EXTRA_LOGPATH = "logPath";

    @m60(baseType = "double")
    @n60({"protocolId=10012,baseType=double,isMustFill=true,isLonLat=true", "protocolId=10013,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_LON = "EXTRA_LON";

    @m60(baseType = "double")
    @n60({"protocolId = 60058,baseType = double,isLonLat = true"})
    public static final String EXTRA_LONGITUDE = "longitude";
    public static final String EXTRA_LONGITUDE_VALUE = "EXTRA_LONGITUDE_VALUE";

    @m60(baseType = "int")
    @n60({"protocolId=10032,baseType=int,isMustFill=false,intValues={-1,1,2,3,4,5,6,7,8,20,24}", "protocolId=10007,baseType=int,isMustFill=false,intValues={-1,1,2,3,4,5,6,7,8,20,24}", "protocolId=10076,baseType=int,isMustFill=false,intValues={-1,1,2,3,4,5,6,7,8,20,24}"})
    public static final String EXTRA_M = "EXTRA_M";

    @m60(baseType = "int")
    @n60({"protocolId = 60046,baseType = int"})
    public static final String EXTRA_MANUFACTUREINFO = "manufactureInfo";

    @m60(baseType = "String")
    @n60({"protocolId = 60034,baseType = String"})
    public static final String EXTRA_MAPDATAPATH = "mapDataPath";

    @m60(baseType = "int")
    @n60({"protocolId = 60068,baseType = int"})
    public static final String EXTRA_MAPFEATURES = "mapFeatures";
    public static final String EXTRA_MAP_DEV = "EXTRA_DEV";

    @m60(baseType = "int")
    @n60({"protocolId=13005,baseType=int,isMustFill=false,maxValue=10,minValue=1"})
    public static final String EXTRA_MAXCOUNT = "EXTRA_MAXCOUNT";

    @m60(baseType = "boolean")
    public static final String EXTRA_MESSAGE_IS_TOP = "EXTRA_MESSAGE_IS_TOP";

    @m60(baseType = "int")
    public static final String EXTRA_MESSAGE_TYPE = "EXTRA_MESSAGE_TYPE";

    @m60(baseType = "String")
    public static final String EXTRA_MIDADDR = "EXTRA_MIDADDR";

    @m60(baseType = "double")
    public static final String EXTRA_MIDLAT = "EXTRA_MIDLAT";

    @m60(baseType = "double")
    public static final String EXTRA_MIDLON = "EXTRA_MIDLON";

    @m60(baseType = "String")
    public static final String EXTRA_MIDNAME = "EXTRA_MIDNAME";

    @m60(baseType = "int")
    @n60({"protocolId=60017,baseType=int,isMustFill=false"})
    public static final String EXTRA_MIN_OFFSET = "minOffset";

    @m60(baseType = "int")
    @n60({"protocolId=10047,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_MUTE = "EXTRA_MUTE";

    @m60(baseType = "double")
    public static final String EXTRA_MYLOCLAT = "EXTRA_MYLOCLAT";

    @m60(baseType = "double")
    public static final String EXTRA_MYLOCLON = "EXTRA_MYLOCLON";

    @m60(baseType = "String")
    public static final String EXTRA_NAME = "EXTRA_NAME";
    public static final String EXTRA_NAVI_INFO = "EXTRA_NAVI_INFO";

    @m60(baseType = "boolean")
    public static final String EXTRA_NAVI_REROUTE_RESULT = "EXTRA_NAVI_REROUTE_RESULT";

    @m60(baseType = "int")
    @n60({"protocolId=12112,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_NAVI_TYPE = "EXTRA_NAVI_TYPE";

    @m60(baseType = "String")
    public static final String EXTRA_NAVI_VIA_INFO = "EXTRA_NAVI_VIA_INFO";

    @m60(baseType = "int")
    @n60({"protocolId=12104,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_NAVI_VIA_MODIFY = "EXTRA_NAVI_VIA_MODIFY";

    @m60(baseType = "int")
    public static final String EXTRA_NAVI_VIA_PASS_CONTROL = "EXTRA_NAVI_VIA_PASS_CONTROL";

    @m60(baseType = "String")
    public static final String EXTRA_NAVI_VIA_PASS_INFO = "EXTRA_NAVI_VIA_PASS_INFO";
    public static final String EXTRA_NEWMODE = "EXTRA_NEWMODE";

    @m60(baseType = "int")
    public static final String EXTRA_NOTIFY_AR_STATUS = "EXTRA_NOTIFY_AR_STATUS";

    @m60(baseType = "int")
    @n60({"protocolId = 60056,baseType = int"})
    public static final String EXTRA_NUM = "num";

    @m60(baseType = "int")
    public static final String EXTRA_OFFSET_X = "EXTRA_OFFSET_X";

    @m60(baseType = "int")
    public static final String EXTRA_OFFSET_Y = "EXTRA_OFFSET_Y";

    @m60(baseType = "int")
    @n60({"protocolId=10014,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_OIL_CUSTOM_STATE = "EXTRA_OIL_CUSTOM_STATE";

    @m60(baseType = "int")
    public static final String EXTRA_OIL_MILEAGE = "EXTRA_OIL_MILEAGE";

    @m60(baseType = "float")
    public static final String EXTRA_OIL_PCT = "EXTRA_OIL_PCT";

    @m60(baseType = "int")
    public static final String EXTRA_OIL_STATE = "EXTRA_OIL_STATE";

    @m60(baseType = "int")
    @n60({"protocolId=10027,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10064,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_OPERA = "EXTRA_OPERA";

    @m60(baseType = "int")
    @n60({"protocolId = 60053,baseType = int"})
    public static final String EXTRA_OPERASELECT = "operaSelect";

    @m60(baseType = "int")
    @n60({"protocolId = 60022,baseType = int"})
    public static final String EXTRA_OPERATIONTYPE = "operationType";
    public static final String EXTRA_OPERATYPE = "operaType";
    public static final String EXTRA_OPERA_ACTIONTYPE = "actionType";
    public static final String EXTRA_OPERA_TYPE = "OPERA_TYPE";

    @m60(baseType = "int")
    @n60({"protocolId=12203,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_OPTION = "EXTRA_OPTION";
    public static final String EXTRA_ORDER_ID = "EXTRA_ORDER_ID";
    public static final String EXTRA_ORDER_PARK_DURATION = "EXTRA_ORDER_PARK_DURATION";
    public static final String EXTRA_ORDER_UNPAID_PRICE = "EXTRA_ORDER_UNPAID_PRICE";
    public static final String EXTRA_OVERSPEED_INFO = "EXTRA_OVERSPEED_INFO";

    @m60(baseType = "int")
    @n60({"protocolId=12201,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_PAGE_OPERATETYPE = "EXTRA_PAGE_OPERATETYPE";

    @m60(baseType = "int")
    @n60({"protocolId=12201,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_PAGE_TURNING = "EXTRA_PAGE_TURNING";

    @m60(baseType = "int")
    @n60({"protocolId=10052,baseType=int,isMustFill=false,maxValue=2,minValue=-1,intValues={-1,0,1,2}"})
    public static final String EXTRA_PARK_DATA = "EXTRA_PARK_DATA";
    public static final String EXTRA_PARK_PAY_RESULT = "EXTRA_PARK_PAY_RESULT";
    public static final String EXTRA_PERCENT_OF_RESIDUAL_ENERGY = "percentOfResidualEnergy";

    @m60(baseType = "String")
    @n60({"protocolId = 60058,baseType = String"})
    public static final String EXTRA_PHONENUMBER = "phoneNumber";

    @m60(baseType = "boolean")
    public static final String EXTRA_PLAN_ROUTE = "EXTRA_PLAN_ROUTE";

    @m60(baseType = "String")
    @n60({"protocolId = 60049,baseType = String,isLonLat = true"})
    public static final String EXTRA_PLATENUMBER = "plateNumber";

    @m60(baseType = "String")
    public static final String EXTRA_PLAY_SOUND_TEXT = "EXTRA_PLAY_SOUND_TEXT";

    @m60(baseType = "String")
    @n60({"protocolId = 60058,baseType = String"})
    public static final String EXTRA_POIID = "poiID";

    @m60(baseType = "String")
    @n60({"protocolId = 60058,baseType = String"})
    public static final String EXTRA_POINAME = "poiName";

    @m60(baseType = "int")
    public static final String EXTRA_POINUM = "EXTRA_POINUM";

    @m60(baseType = "String")
    public static final String EXTRA_POITYPE = "EXTRA_POITYPE";

    @m60(baseType = "String")
    public static final String EXTRA_POI_ID = "POIID";

    @m60(baseType = "String")
    public static final String EXTRA_POI_RESULT = "EXTRA_POI_RESULT";

    @m60(baseType = "int")
    public static final String EXTRA_POPUP_ID = "POPUP_ID";
    public static final String EXTRA_POWERTYPE = "powerType";

    @m60(baseType = "String")
    @n60({"protocolId=12116,baseType=String,isMustFill=true"})
    public static final String EXTRA_PRODUCT_MODEL = "productModel";

    @m60(baseType = "String")
    @n60({"protocolId=12116,baseType=String,isMustFill=true"})
    public static final String EXTRA_PRODUCT_NAME = "productName";

    @m60(baseType = "String")
    public static final String EXTRA_PROVICE = "PROVINCE_NAME";

    @m60(baseType = "int")
    public static final String EXTRA_RANGE = "EXTRA_RANGE";
    public static final String EXTRA_RECOMMEND = "EXTRA_RECOMMEND";

    @m60(baseType = "boolean")
    public static final String EXTRA_RECYLE_SIMUNAVI = "KEY_RECYLE_SIMUNAVI";
    public static final String EXTRA_REDLIGHTCOUNTDOWNSECONDS = "redLightCountDownSeconds";
    public static final String EXTRA_REQUESTCODE = "EXTRA_REQUESTCODE";
    public static final String EXTRA_REQUESTMAPDOWLOAD = "requestMapdowload";

    @m60(baseType = "int")
    @n60({"protocolId = 60058,baseType = int"})
    public static final String EXTRA_REQUESTTYPE = "requestType";

    @m60(baseType = "int")
    @n60({"protocolId=12404,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_REQUEST_AUTO_STATE = "EXTRA_REQUEST_AUTO_STATE";

    @m60(baseType = "int")
    public static final String EXTRA_REQUEST_ID = "EXTRA_REQUEST_ID";

    @m60(baseType = "boolean")
    public static final String EXTRA_REQUEST_IS_WHAT = "EXTRA_REQUEST_IS_WHAT";

    @m60(baseType = "boolean")
    public static final String EXTRA_REQUEST_RESULT = "EXTRA_REQUEST_RESULT";
    public static final String EXTRA_RESIDUAL_ENERGY = "residualEnergy";

    @m60(baseType = "int")
    @n60({"protocolId = 60059,baseType = int"})
    public static final String EXTRA_RESPONSETYPE = "responseType";

    @m60(baseType = "int")
    public static final String EXTRA_RESPONSE_CODE = "EXTRA_RESPONSE_CODE";

    @m60(baseType = "String")
    public static final String EXTRA_RESULT = "EXTRA_RESULT";

    @m60(baseType = "String")
    public static final String EXTRA_ROAD_INFO = "EXTRA_ROAD_INFO";
    public static final String EXTRA_ROUTE = "route";

    @m60(baseType = "String")
    public static final String EXTRA_ROUTE_REFRESH_INFO = "EXTRA_ROUTE_REFRESH_INFO";

    @m60(baseType = "boolean")
    public static final String EXTRA_SAFEDRIVING_DISPLAY = "EXTRA_SAFEDRIVING_DISPLAY";

    @m60(baseType = "int")
    public static final String EXTRA_SAFEDRIVING_TYPE = "EXTRA_SAFEDRIVING_TYPE";

    @m60(baseType = "String")
    public static final String EXTRA_SCREENSHOT_PATH = "EXTRA_SCREENSHOT_PATH";

    @m60(baseType = "int")
    @n60({"protocolId=12201,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_SCREEN_TURNING = "EXTRA_SCREEN_TURNING";

    @m60(baseType = "String")
    public static final String EXTRA_SEARCHCITY = "EXTRA_CITY";

    @m60(baseType = "int")
    @n60({"protocolId=13005,baseType=int,isMustFill=false,maxValue=1,minValue=1,intValues={1}", "protocolId=10023,baseType=int,isMustFill=true,maxValue=0,minValue=0,intValues={0}", "protocolId=10024,baseType=int,isMustFill=true,maxValue=1,minValue=1,intValues={1}", "protocolId=10057,baseType=int,isMustFill=false,maxValue=7,minValue=1,intValues={1,2,3,4,5,6,7}"})
    public static final String EXTRA_SEARCHTYPE = "EXTRA_SEARCHTYPE";

    @m60(baseType = "String")
    public static final String EXTRA_SEARCH_ALONG_THE_WAY = "EXTRA_SEARCH_ALONG_THE_WAY";
    public static final String EXTRA_SEARCH_INFO = "EXTRA_SEARCH_INFO";

    @m60(baseType = "boolean")
    public static final String EXTRA_SEND2CAR_DATA = "EXTRA_SEND2CAR_DATA";

    @m60(baseType = "String")
    @n60({"protocolId=12116,baseType=String"})
    public static final String EXTRA_SERVICE_ACTION = "serviceAction";

    @m60(baseType = "boolean")
    public static final String EXTRA_SETTING_RESULT = "EXTRA_SETTING_RESULT";

    @m60(baseType = "boolean")
    public static final String EXTRA_SETTING_RESULT_BACKGROUND_DOG = "EXTRA_SETTING_RESULT_BACKGROUND_DOG";

    @m60(baseType = "boolean")
    public static final String EXTRA_SETTING_RESULT_CROSS_AREA = "EXTRA_SETTING_RESULT_CROSS_AREA";

    @m60(baseType = "boolean")
    public static final String EXTRA_SETTING_RESULT_DOG = "EXTRA_SETTING_RESULT_DOG";

    @m60(baseType = "boolean")
    public static final String EXTRA_SETTING_RESULT_ROAD = "EXTRA_SETTING_RESULT_ROAD";

    @m60(baseType = "boolean")
    public static final String EXTRA_SETTING_RESULT_WARN = "EXTRA_SETTING_RESULT_WARN";

    @m60(baseType = "int")
    @n60({"protocolId=12006,baseType=int,isMustFill=false,maxValue=1,minValue=1,intValues={1}", "protocolId=12007,baseType=int,isMustFill=false,maxValue=1,minValue=1,intValues={1}"})
    public static final String EXTRA_SETTING_TYPE = "EXTRA_SETTING_TYPE";

    @m60(baseType = "boolean")
    @n60({"protocolId = 60031,baseType = boolean"})
    public static final String EXTRA_SHOWNOAINFO = "showNOAInfo";

    @m60(baseType = "int")
    @n60({"protocolId=10008,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_SHOW_TYPE = "EXTRA_SHOW_TYPE";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_SLAT = "EXTRA_SLAT";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_SLON = "EXTRA_SLON";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_SMIDLAT = "EXTRA_SMIDLAT";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_SMIDLON = "EXTRA_SMIDLON";

    @m60(baseType = "String")
    @n60({"protocolId=10076,baseType=String,isMustFill=true"})
    public static final String EXTRA_SMIDNAME = "EXTRA_SMIDNAME";

    @m60(baseType = "String")
    public static final String EXTRA_SMID_POI_ID = "EXTRA_SMID_POI_ID";

    @m60(baseType = "String")
    @n60({"protocolId=10076,baseType=String,isMustFill=true"})
    public static final String EXTRA_SNAME = "EXTRA_SNAME";

    @m60(baseType = "int")
    @n60({"protocolId=10023,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10024,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_SORTORDER = "EXTRA_SORTORDER";

    @m60(baseType = "String")
    @n60({"protocolId=10101,baseType=String,isMustFill=true", "protocolId=10102,baseType=String,isMustFill=true"})
    public static final String EXTRA_SOURCE_APP = "SOURCE_APP";

    @m60(baseType = "String")
    @n60({"protocolId=10101,baseType=String,isMustFill=true", "protocolId=10102,baseType=String,isMustFill=true"})
    public static final String EXTRA_SOURCE_APP_NAME = "SOURCE_APP_NAME";

    @m60(baseType = "boolean")
    public static final String EXTRA_START_NAVI = "EXTRA_START_NAVI";

    @m60(baseType = "int")
    @n60({"protocolId=10017,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_STATE = "EXTRA_STATE";

    @m60(baseType = "int")
    @n60({"protocolId = 60026,baseType = int,isMustFill=true,intValues={0,1,2,3,4,5,6,7}"})
    public static final String EXTRA_STATETYPE = "stateType";
    public static final String EXTRA_STATEVALUE = "stateValue";

    @m60(baseType = "int")
    @n60({"protocolId=10019,baseType=int,isMustFill=false"})
    public static final String EXTRA_STATUS_DETAILS = "EXTRA_STATUS_DETAILS";

    @m60(baseType = "String")
    public static final String EXTRA_S_POI_ID = "EXTRA_S_POI_ID";

    @m60(baseType = "int")
    public static final String EXTRA_TEST_ID = "EXTRA_TEST_ID";

    @m60(baseType = "String")
    public static final String EXTRA_TEST_PARAM = "EXTRA_TEST_PARAM";

    @m60(baseType = "String")
    public static final String EXTRA_TEST_RESULT = "EXTRA_TEST_RESULT";

    @m60(baseType = "int")
    @n60({"protocolId=13037,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_TMC_DISPATCH_ENABLE = "EXTRA_TMC_DISPATCH_ENABLE";

    @m60(baseType = "String")
    public static final String EXTRA_TMC_SEGMENT = "EXTRA_TMC_SEGMENT";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_TMIDLAT = "EXTRA_TMIDLAT";

    @m60(baseType = "double")
    @n60({"protocolId=10076,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String EXTRA_TMIDLON = "EXTRA_TMIDLON";

    @m60(baseType = "String")
    @n60({"protocolId=10076,baseType=String,isMustFill=true"})
    public static final String EXTRA_TMIDNAME = "EXTRA_TMIDNAME";

    @m60(baseType = "String")
    public static final String EXTRA_TMID_POI_ID = "EXTRA_TMID_POI_ID";
    public static final String EXTRA_TRAFFICLIGHTSTATUS = "trafficLightStatus";

    @m60(baseType = "String")
    public static final String EXTRA_TRAFFIC_CONDITION = "EXTRA_TRAFFIC_CONDITION";

    @m60(baseType = "int")
    public static final String EXTRA_TRAFFIC_CONDITION_RESULT = "EXTRA_TRAFFIC_CONDITION_RESULT";
    public static final int EXTRA_TRAFFIC_CONDITION_RESULT_CITY_NOT_SUPPORT = 4;
    public static final int EXTRA_TRAFFIC_CONDITION_RESULT_ERROR = 5;
    public static final int EXTRA_TRAFFIC_CONDITION_RESULT_LINE_NOT_FOUND = 3;

    @m60(baseType = "String")
    public static final String EXTRA_TRAFFIC_CONDITION_RESULT_MESSAGE = "EXTRA_TRAFFIC_CONDITION_RESULT_MESSAGE";
    public static final int EXTRA_TRAFFIC_CONDITION_RESULT_NET_ERROR = 2;
    public static final int EXTRA_TRAFFIC_CONDITION_RESULT_SUCCESS = 1;

    @m60(baseType = "int")
    @n60({"protocolId = 60071,baseType = int"})
    public static final String EXTRA_TRUCK_POWERTYPE = "powerType";

    @m60(baseType = "int")
    @n60({"protocolId=10027,baseType=int,isMustFill=true,maxValue=2,minValue=0,intValues={0,1,2}", "protocolId=10064,baseType=int,isMustFill=false,maxValue=4,minValue=0,intValues={0,1,2,3,4}", "protocolId=10070,baseType=int,isMustFill=false,maxValue=5,minValue=0,intValues={0,1,2,3,4,5}", "protocolId=12013,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10058,baseType=int,isMustFill=false,maxValue=2,minValue=1,intValues={1,2}", "protocolId=10045,baseType=int,isMustFill=false,maxValue=3,minValue=1,intValues={1,2,3}", "protocolId=10017,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10016,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String EXTRA_TYPE = "EXTRA_TYPE";
    public static final String EXTRA_TYPE_NEW = "type";

    @m60(baseType = "String")
    @n60({"protocolId = 60034,baseType = String"})
    public static final String EXTRA_USERDATAPATH = "userDataPath";

    @m60(baseType = "String")
    @n60({"protocolId=10101,baseType=String,isMustFill=true", "protocolId=10102,baseType=String,isMustFill=true"})
    public static final String EXTRA_USER_DEVICE_ID = "USER_DEVICE_ID";

    @m60(baseType = "String")
    public static final String EXTRA_USER_LOGIN_AVATA = "USER_LOGIN_AVATA";

    @m60(baseType = "String")
    @n60({"protocolId=10101,baseType=String,isMustFill=true", "protocolId=10102,baseType=String,isMustFill=true"})
    public static final String EXTRA_USER_LOGIN_ID = "USER_LOGIN_ID";

    @m60(baseType = "String")
    public static final String EXTRA_USER_LOGIN_NAME = "USER_LOGIN_NAME";

    @m60(baseType = "String")
    public static final String EXTRA_USER_LOGOUT_ID = "USER_LOGOUT_ID";

    @m60(baseType = "String")
    public static final String EXTRA_USER_LOGOUT_PHONE = "USER_LOGOUT_PHONE";

    @m60(baseType = "String")
    public static final String EXTRA_USER_REQUEST_TIME = "USER_REQUEST_TIME";

    @m60(baseType = "int")
    @n60({"protocolId=10081,baseType=int,isMustFill=false,maxValue=6,minValue=1,intValues={1,2,3,4,5,6}"})
    public static final String EXTRA_VIEWTYPE = "EXTRA_VIEWTYPE";

    @m60(baseType = "boolean")
    public static final String EXTRA_VOICE_CONTROL_AVOID_TRAFFIC_JAM = "EXTRA_VOICE_CONTROL_AVOID_TRAFFIC_JAM";

    @m60(baseType = "int")
    @n60({"protocolId=12403,baseType=int,isMustFill=false,maxValue=1,minValue=1,intValues={1}"})
    public static final String EXTRA_VOICE_CONTROL_NAME_TYPE = "EXTRA_VOICE_CONTROL_NAME_TYPE";

    @m60(baseType = "boolean")
    public static final String EXTRA_VOICE_CONTROL_PARK = "EXTRA_VOICE_CONTROL_PARK";
    public static final String EXTRA_WAITROUND = "waitRound";
    public static final String EXTRA_WIDGET_SERVICE_STATUS = "EXTRA_WIDGET_SERVICE_STATUS";

    @m60(baseType = "int")
    @n60({"protocolId=12111,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String EXTRA_WIPE_STATE = "EXTRA_WIPE_STATE";
    public static final String EXTRA__FINGER_OPERA_TYPE = "EXTRA_OPERA_TYPE";

    @m60(baseType = "String")
    public static final String FROM_POI_ADDR = "FromPoiAddr";

    @m60(baseType = "String")
    public static final String FROM_POI_LATITUDE = "FromPoiLatitude";

    @m60(baseType = "String")
    public static final String FROM_POI_LONGUTUDE = "FromPoiLongitude";

    @m60(baseType = "String")
    public static final String FROM_POI_NAME = "FromPoiName";

    @m60(baseType = "String")
    public static final String FROM_POI_TYPE = "FromPoiType";

    @m60(baseType = "int")
    @n60({"protocolId=12107,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String HUD_IS_OPEN = "HUD_IS_OPEN";

    @m60(baseType = "int")
    @n60({"protocolId=13005,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String IS_CANCEL = "IS_CANCEL";

    @m60(baseType = "boolean")
    public static final String IS_MANUAL_TRAFFIC_REPORT_GUIDE = "IS_MANUAL_TRAFFIC_REPORT_GUIDE";

    @m60(baseType = "boolean")
    public static final String IS_REPORT_VIEW_CLOSE = "IS_REPORT_VIEW_CLOSE";

    @m60(baseType = "boolean")
    public static final String IS_REPORT_VIEW_SHOW = "IS_REPORT_VIEW_SHOW";

    @m60(baseType = "int")
    @n60({"protocolId=13005,baseType=int,isMustFill=false,maxValue=1,minValue=0,intValues={0,1}", "protocolId=10040,baseType=int,isMustFill=true,maxValue=1,minValue=0,intValues={0,1}"})
    public static final String IS_START_NAVI = "IS_START_NAVI";

    @m60(baseType = "String")
    @n60({"protocolId=10036,baseType=String,isMustFill=true", "protocolId=10037,baseType=String,isMustFill=true"})
    public static final String KEYWORDS = "KEYWORDS";

    @m60(baseType = "boolean")
    public static final String KEY_BOOLEAN_IS_CHARGING = "IS_CHARGE";

    @m60(baseType = "int")
    public static final String KEY_CODE = "KEY_CODE";

    @m60(baseType = "doubleArray")
    public static final String KEY_DOUBLE_ARRAY_CURVE_COSTLIST = "CURVE_COSTLIST";

    @m60(baseType = "doubleArray")
    public static final String KEY_DOUBLE_ARRAY_SLOPE_COSTLIST = "SLOPE_COSTLIST";

    @m60(baseType = "doubleArray")
    public static final String KEY_DOUBLE_ARRAY_SPEED_COSTLIST = "SPEED_COSTLIST";

    @m60(baseType = "doubleArray")
    public static final String KEY_DOUBLE_ARRAY_TRANS_COSTLIST = "TRANS_COSTLIST";

    @m60(baseType = "double")
    public static final String KEY_DOUBLE_AUX_COST = "AUX_COST";

    @m60(baseType = "double")
    public static final String KEY_DOUBLE_CURRENT_BATTERY_AMOUNT = "INITIAL_HV_BATTENERGY";

    @m60(baseType = "double")
    public static final String KEY_DOUBLE_FERRYRATE_COST = "FERRYRATE_COST";

    @m60(baseType = "double")
    public static final String KEY_DOUBLE_MAX_BATTERY_AMOUNT = "MAX_BATT_ENERGY";

    @m60(baseType = "double")
    public static final String KEY_DOUBLE_PERCENT_OF_RESIDUAL_ENERGY = "PERCENT_OF_RESIDUAL_ENERGY";

    @m60(baseType = "boolean")
    public static final String KEY_DRIVE_WAY_ENABLED = "drive_way_enabled";
    public static final String KEY_DRIVE_WAY_INFO = "drive_way_info";

    @m60(baseType = "String")
    public static final String KEY_DRIVE_WAY_LANE_BACK_ICON = "drive_way_lane_Back_icon";

    @m60(baseType = "String")
    public static final String KEY_DRIVE_WAY_LANE_EXTENDED = "drive_way_lane_Extended";

    @m60(baseType = "int")
    public static final String KEY_DRIVE_WAY_NUMBER = "drive_way_number";

    @m60(baseType = "int")
    public static final String KEY_DRIVE_WAY_SIZE = "drive_way_size";

    @m60(baseType = "int")
    public static final String KEY_EXTSCREEN_MAP_VIEW = "EXTSCREEN_MAP_VIEW";

    @m60(baseType = "int")
    public static final String KEY_EXTSCREEN_MINI_MAP = "EXTSCREEN_MINI_MAP";

    @m60(baseType = "int")
    public static final String KEY_EXTSCREEN_MODE_INFO = "EXTSCREEN_MODE_INFO";

    @m60(baseType = "int")
    @n60({"protocolId=10116,baseType=int,isMustFill=false,maxValue=9,minValue=0,intValues={0,1,2,9}"})
    public static final String KEY_EXTSCREEN_OPERATE_TYPE = "EXTSCREEN_OPERATE_TYPE";

    @m60(baseType = "int")
    @n60({"protocolId=10117,baseType=int,isMustFill=false,maxValue=2,minValue=0,intValues={0,1,2}"})
    public static final String KEY_EXTSCREEN_STATUS_INFO = "EXTSCREEN_STATUS_INFO";

    @m60(baseType = "int")
    public static final String KEY_EXTSCREEN_WINDOW_INFO = "EXTSCREEN_WINDOW_INFO";

    @m60(baseType = "int")
    public static final String KEY_INT_ADDITION_COMSUP = "ADDITION_COMSUP_TYPE";

    @m60(baseType = "int")
    @n60({"protocolId=13023,baseType=int,isMustFill=false,maxValue=101,minValue=100,intValues={100,101}"})
    public static final String KEY_INT_CHARGE_STATE = "CHARGE_STATE";

    @m60(baseType = "int")
    @n60({"protocolId=13023,baseType=int,isMustFill=false,maxValue=3,minValue=1,intValues={1,2,3}"})
    public static final String KEY_INT_CHARGE_TYPE = "CHARGE_TYPE";

    @m60(baseType = "int")
    @n60({"protocolId=13024,baseType=int,isMustFill=false,maxValue=4,minValue=0,intValues={0,1,2,3,4}"})
    public static final String KEY_INT_DRIVEMODE_STATE = "DRIVEMODE_STATE";

    @m60(baseType = "int")
    public static final String KEY_INT_DRIVE_MODE = "CUR_DRIVE_MODE";

    @m60(baseType = "int")
    public static final String KEY_INT_ENERGY_UNIT = "ENERGY_UNIT";

    @m60(baseType = "int")
    public static final String KEY_INT_LOW_ENERGY_ALERT = "LOW_ENERGY_ALERT";

    @m60(baseType = "int")
    public static final String KEY_INT_RANGE_DISTANCE = "RANGE_DIST";

    @m60(baseType = "int")
    public static final String KEY_INT_TOP_SPEED = "TOP_SPEED";

    @m60(baseType = "int")
    public static final String KEY_INT_VEHICLE_WEIGHT = "VEHICLE_WEIGHT";

    @m60(baseType = "String")
    public static final String KEY_POWERTRAIN_LOSS = "POWERTRAIN_LOSS";

    @m60(baseType = "boolean")
    public static final String KEY_POWER_INFO_TEST = "POWER_INFO_TEST";
    public static final String KEY_SPEEDOMETER_VALUE = "KEY_SPEEDOMETER_VALUE";
    public static final String KEY_TRAFFIC_LANE_ADVISED = "trafficLaneAdvised";
    public static final String KEY_TRAFFIC_LANE_EXTENDEDNEW = "trafficLaneExtendedNew";
    public static final String KEY_TRAFFIC_LANE_TYPE = "trafficLaneType";

    @m60(baseType = "int")
    public static final String KEY_TYPE = "KEY_TYPE";
    public static final String KEY_VIA_POIS = "KEY_VIA_POIS";

    @m60(baseType = "int")
    public static final String KEY_VIA_POIS_SIZE = "KEY_VIA_POIS_SIZE";
    public static final int LAMP_OFF = 1;
    public static final int LAMP_ON = 0;

    @m60(baseType = "double")
    @n60({"protocolId=10037,baseType=double,isMustFill=false,isLonLat=true", "protocolId=10038,baseType=double,isMustFill=true,isLonLat=true", "protocolId=10039,baseType=double,isMustFill=true,isLonLat=true", "protocolId=10058,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String LAT = "LAT";

    @m60(baseType = "double")
    public static final String LATITUDE = "latitude";
    public static final String LIMIT_SPEED_SPEED = "LIMIT_SPEED_SPEED";

    @m60(baseType = "double")
    @n60({"protocolId=10037,baseType=double,isMustFill=false,isLonLat=true", "protocolId=10038,baseType=double,isMustFill=true,isLonLat=true", "protocolId=10039,baseType=double,isMustFill=true,isLonLat=true", "protocolId=10058,baseType=double,isMustFill=true,isLonLat=true"})
    public static final String LON = "LON";

    @m60(baseType = "double")
    public static final String LONGITUDE = "longitude";
    public static final int MESSAGE_PRIORITY_OIL_ALERT = 3;

    @m60(baseType = "String")
    public static final String METHOD = "method";

    @m60(baseType = "int")
    public static final String MID_POIS_NUM = "midPoisNum";

    @m60(baseType = "String")
    public static final String MID_POI_ADDR = "MidPoiAddr";
    public static final String MID_POI_ARRAY = "midPoiArray";

    @m60(baseType = "String")
    public static final String MID_POI_LATITUDE = "MidPoiLatitude";

    @m60(baseType = "String")
    public static final String MID_POI_LONGITUDE = "MidPoiLongitude";

    @m60(baseType = "String")
    public static final String MID_POI_NAME = "MidPoiName";

    @m60(baseType = "String")
    public static final String MID_POI_TYPE = "MidPoiType";
    public static final String MID_VIA_ENTRYLATITUDE = "viaEntryLatitude";
    public static final String MID_VIA_ENTRYLONGITUDE = "viaEntryLongitude";
    public static final String MID_VIA_POIID = "viaPoiid";
    public static final int MUTE = 1;
    public static final int MUTE_CANCEL = 0;

    @m60(baseType = "String")
    public static final String NAME = "name";
    public static final String NAVI_FROM_NAME = "NAVI_FROM_NAME";

    @m60(baseType = "int")
    @n60({"protocolId=10005,baseType=int,isMustFill=false,intValues={1,2,3,4,5,6,7,8,20,24}"})
    public static final String NAVI_ROUTE_PREFER = "NAVI_ROUTE_PREFER";
    public static final String NAVI_SPEED = "NAVI_SPEED";
    public static final String NAVI_TOTALTIME = "NAVI_TOTALTIME";
    public static final String NAVI_TO_NAME = "NAVI_TO_NAME";
    public static final int NAVI_VIA_MODIFY_ADD_ONE = 1;
    public static final int NAVI_VIA_MODIFY_DEL_ALL = 0;
    public static final int NAVI_VIA_MODIFY_DEL_ONE = 2;

    @m60(baseType = "String")
    public static final String NUM_SPACE_F = "num_space_f";
    public static final String ODD_NUM = "oddNum";
    public static final String OVERSPEED_LAT = "OVERSPEED_LAT";
    public static final String OVERSPEED_LON = "OVERSPEED_LON";
    public static final String OVERSPEED_SPEED = "OVERSPEED_SPEED";
    public static final String OVERSPEED_TIME = "OVERSPEED_TIME";

    @m60(baseType = "String")
    public static final String PARAMETER_TYPE = "PARAMETER_TYPE";

    @m60(baseType = "int")
    public static final String PARAM_VAR1 = "PARAM_VAR1";

    @m60(baseType = "int")
    public static final String PARAM_VAR2 = "PARAM_VAR2";

    @m60(baseType = "int")
    public static final String PARAM_VAR3 = "PARAM_VAR3";

    @m60(baseType = "int")
    public static final String PARAM_VAR4 = "PARAM_VAR4";

    @m60(baseType = "int")
    public static final String PARK_DISTANCE = "parkDistance";

    @m60(baseType = "int")
    public static final String PARK_INDEX = "parkIndex";

    @m60(baseType = "String")
    public static final String PARK_NAME = "parkName";

    @m60(baseType = "String")
    public static final String PARK_PRICE = "parkPrice";
    public static final String PATH_INFO = "path_info";

    @m60(baseType = "int")
    public static final String PATH_NUM = "pathNum";

    @m60(baseType = "String")
    public static final String PHONE = "phone";

    @m60(baseType = "String")
    public static final String POICATEGORY = "extra_poitype";

    @m60(baseType = "String")
    public static final String POIDEEPINFO = "poideepinfo";

    @m60(baseType = "int")
    public static final String POIDEEPINFO_CATEGORY = "category";

    @m60(baseType = "String")
    public static final String POIDEEPINFO_CHARGE_BRAND_DESC = "brand_desc";

    @m60(baseType = "String")
    public static final String POIDEEPINFO_CHARGE_CSCF_TYPE = "cscf_type";

    @m60(baseType = "int")
    public static final String POIDEEPINFO_CHARGE_IDEL_QUICK = "idel_quick";

    @m60(baseType = "int")
    public static final String POIDEEPINFO_CHARGE_IDEL_SLOW = "idel_slow";

    @m60(baseType = "int")
    public static final String POIDEEPINFO_CHARGE_TOTAL_QUICK = "total_quick";

    @m60(baseType = "int")
    public static final String POIDEEPINFO_CHARGE_TOTAL_SLOW = "total_slow";

    @m60(baseType = "String")
    public static final String POIDEEPINFO_TAG = "tag";
    public static final String POIDEEPINFO_TAGINFO = "taginfo";

    @m60(baseType = "String")
    public static final String POIDEEPINFO_TAGINFO_PARKINGINFO = "parkinginfo";

    @m60(baseType = "String")
    public static final String POIDEEPINFO_TAGINFO_PRICE = "price";

    @m60(baseType = "String")
    public static final String POIDEEPINFO_TAGINFO_PRICEINFO = "priceinfo";

    @m60(baseType = "String")
    public static final String POIDEEPINFO_TAGINFO_PRICETAG = "pricetag";

    @m60(baseType = "String")
    public static final String POIDEEPINFO_TAGINFO_TYPE = "type";

    @m60(baseType = "String")
    public static final String POIID = "poiid";

    @m60(baseType = "String")
    @n60({"protocolId=10039,baseType=String,isMustFill=true"})
    public static final String POINAME = "POINAME";

    @m60(baseType = "int")
    public static final String POITYPE = "poitype";

    @m60(baseType = "String")
    public static final String POI_ADDR = "addr";

    @m60(baseType = "String")
    public static final String POI_ADDRESS = "address";
    public static final int POI_DEEPINFO_CATEGORY_GASSTATION = 1;
    public static final int POI_DEEPINFO_CATEGORY_HOTEL = 2;
    public static final int POI_DEEPINFO_CATEGORY_PARKING = 0;

    @m60(baseType = "int")
    public static final String POI_DISTANCE = "distance";

    @m60(baseType = "String")
    public static final String POI_ID = "poiId";

    @m60(baseType = "String")
    public static final String PROVIDER = "provider";

    @m60(baseType = "int")
    @n60({"protocolId=12108,baseType=int,isMustFill=false,maxValue=5,minValue=1"})
    public static final String REPORT_EVENT_TYPE = "REPORT_EVENT_TYPE";

    @m60(baseType = "int")
    @n60({"protocolId=12108,baseType=int,isMustFill=false,maxValue=2,minValue=1,intValues={1,2}"})
    public static final String REPORT_OPERATE_TYPE = "REPORT_OPERATE_TYPE";
    public static final int REPORT_OPERATE_TYPE_REPORT_EVENT = 1;
    public static final int REPORT_OPERATE_TYPE_VIEW_OPERATE = 2;

    @m60(baseType = "String")
    public static final String REPORT_PICTURE_PATH = "KEY_PICTURE_PATH";

    @m60(baseType = "long")
    public static final String REPORT_PICTURE_TIME = "KEY_PICTURE_TIME";

    @m60(baseType = "int")
    public static final String REPORT_RESULT_CODE = "REPORT_RESULT_CODE";
    public static final int REPORT_RESULT_NET_UNCONNECTED = 2;
    public static final int REPORT_RESULT_REPORT_COMPLETE = 1;

    @m60(baseType = "int")
    @n60({"protocolId=12108,baseType=int,isMustFill=false,maxValue=2,minValue=1,intValues={1,2}"})
    public static final String REPORT_TYPE = "REPORT_TYPE";
    public static final int REPORT_TYPE_AMBIGUOUS = 1;
    public static final int REPORT_TYPE_MANUAL = 0;
    public static final int REPORT_TYPE_PRECISE = 2;

    @m60(baseType = "int")
    @n60({"protocolId=12108,baseType=int,isMustFill=false,maxValue=2,minValue=1,,intValues={1,2}"})
    public static final String REPORT_VIEW_OPERATE = "REPORT_VIEW_OPERATE";
    public static final int REPORT_VIEW_OPERATE_CANCEL = 2;
    public static final int REPORT_VIEW_OPERATE_REPORT = 1;
    public static final int REQUEST_BACKGROUND_STATE = 0;
    public static final int REQUEST_NAVIGATING_STATE = 1;
    public static final String ROLL_VALID = "rollValid";
    public static final String ROLL_VALUE = "rollValue";
    public static final String ROUTEINFO_VIAPOIDISTANCE = "viaPOIdistance";
    public static final String ROUTEINFO_VIAPOITIME = "viaPOItime";
    public static final String SEARCH_KEYWORD = "SEARCH_KEYWORD";

    @m60(baseType = "int")
    public static final String SEARCH_RESULT_CODE = "SEARCH_RESULT_CODE";
    public static final String SEARCH_TIME = "SEARCH_TIME";
    public static final String SEARCH_TYPE = "SEARCH_TYPE";
    public static final int SEARCH_TYPE_CATAGORY = 1;
    public static final int SEARCH_TYPE_KEYWORD = 0;

    @m60(baseType = "boolean")
    public static final String SLOPE_VALID = "slopeValid";

    @m60(baseType = "float")
    public static final String SLOPE_VALUE = "slopeValue";

    @m60(baseType = "String")
    public static final String SOURCE_APP = "SOURCE_APP";

    @m60(baseType = "float")
    public static final String SPEED = "speed";
    public static final String STREET_NAMES = "streetNames";

    @m60(baseType = "int")
    public static final String STREET_NAME_SIZE = "streetNamesSize";

    @m60(baseType = "int")
    @n60({"protocolId=10038,baseType=int,isMustFill=true,intValues={-1,1,2,3,4,5,6,7,8,20,24}"})
    public static final String STYLE = "STYLE";
    public static final int[] STYLE_TYPE_ARRAY = {1, 2, 3, 4, 5, 6, 7, 8, 20, 24};

    @m60(baseType = "String")
    public static final String TAG_CATEGORY = "tag_category";

    @m60(baseType = "String")
    public static final String TEL = "tel";

    @m60(baseType = "long")
    public static final String TIME = "time";

    @m60(baseType = "String")
    public static final String TIME_AUTO = "time_AUTO";
    public static final String TOTAL_ODD_DISTANCE = "totalOddDistance";
    public static final String TO_ENDPOIID = "endPoiid";

    @m60(baseType = "String")
    public static final String TO_POI_ADDR = "ToPoiAddr";

    @m60(baseType = "String")
    public static final String TO_POI_LATITUDE = "ToPoiLatitude";

    @m60(baseType = "String")
    public static final String TO_POI_LONGITUDE = "ToPoiLongitude";

    @m60(baseType = "String")
    public static final String TO_POI_NAME = "ToPoiName";

    @m60(baseType = "String")
    public static final String TO_POI_TYPE = "ToPoiType";

    @m60(baseType = "int")
    public static final String TYPE_HOME_COMPANY_RESULT = "HOME_COMPANY_RESULT";

    @m60(baseType = "String")
    public static final String TYPE_HOME_COMPANY_TRAFFIC = "MESSAGE_COMPONENT_TRAFFIC_INFO";

    @m60(baseType = "String")
    public static final String TYPE_MESSAGE_COMPONENT_RESULT = "MESSAGE_COMPONENT_RESULT";

    @m60(baseType = "int")
    public static final String TYPE_MESSAGE_COMPONENT_SHOW_OR_DISMISS = "MESSAGE_COMPONENT_SHOW_OR_DISMISS";

    @m60(baseType = "int")
    public static final String TYPE_MESSAGE_COMPONENT_TYPE = "MESSAGE_COMPONENT_TYPE";
    public static final int TYPE_SETTING_MAP_BACKGROUND_DOG = 1;
    public static final String TYPE_TRAFFIC_RESTRICT_INFO_RESULT = "TRAFFIC_RESTRICT_INFO_RESULT";

    @m60(baseType = "String")
    public static final String VERSION_NUM = "VERSION_NUM";

    @m60(baseType = "int")
    @n60({"protocolId=10044,baseType=int,isMustFill=false,maxValue=10,minValue=0,intValues={0,1,2,3,4,5,6,7,8,9,10}"})
    public static final String VOICE_ROLE = "VOICE_ROLE";
    public static final String WIDGET_GOCOMPANY_EXTRA = "widget_gocompany_extra";
    public static final String WIDGET_GOHOME_EXTRA = "widget_gohome_extra";

    @m60(baseType = "int")
    public static final String WIDGET_STATE = "WIDGET_STATE";
}
