package com.autonavi.amapauto.protocol.data.search;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class Category_JsonLubeParser implements Serializable {
    public static Category parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        Category category = new Category();
        category.a = jSONObject.optString("ctype", category.a);
        category.c = jSONObject.optString(StandardProtocolKey.NAME, category.c);
        JSONArray optJSONArray = jSONObject.optJSONArray("categoryItems");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList arrayList = new ArrayList(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(CategoryItem_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            category.d = arrayList;
        }
        category.e = jSONObject.optString("checkedvalue", category.e);
        return category;
    }
}
