package com.autonavi.amapauto.protocol.data.search;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class Poi_JsonLubeParser implements Serializable {
    public static Poi parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        Poi poi = new Poi();
        JSONArray optJSONArray = jSONObject.optJSONArray("enteryList");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList arrayList = new ArrayList(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(EnteryList_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            poi.a = arrayList;
        }
        poi.c = Biz_ext_JsonLubeParser.parse(jSONObject.optJSONObject("biz_ext"));
        poi.d = jSONObject.optString("Name", poi.d);
        poi.e = jSONObject.optInt(StandardProtocolKey.POI_DISTANCE, poi.e);
        poi.f = jSONObject.optString("Typecode", poi.f);
        poi.g = jSONObject.optDouble("longitude", poi.g);
        poi.h = jSONObject.optInt("distaceToSearchLocation", poi.h);
        JSONArray optJSONArray2 = jSONObject.optJSONArray("childPoiList");
        if (optJSONArray2 != null) {
            int length2 = optJSONArray2.length();
            ArrayList arrayList2 = new ArrayList(length2);
            for (int i2 = 0; i2 < length2; i2++) {
                arrayList2.add(ChildPoiList_JsonLubeParser.parse(optJSONArray2.optJSONObject(i2)));
            }
            poi.i = arrayList2;
        }
        poi.j = jSONObject.optString("Address", poi.j);
        poi.k = jSONObject.optDouble("Latitude", poi.k);
        poi.l = jSONObject.optString("Tel", poi.l);
        poi.m = jSONObject.optString("Poiid", poi.m);
        poi.n = jSONObject.optInt("homecopType", poi.n);
        return poi;
    }
}
