package com.autonavi.amapauto.protocol.model.base;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import defpackage.aa0;
import defpackage.gd;
import defpackage.p80;
import defpackage.s90;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class ProtocolBaseModel implements Parcelable {
    public int callbackId;
    public String clientPackageName;
    public String packageName;
    public int protocolID;
    public String protocolVersion;
    public long timeStamp;
    public String var1;

    public ProtocolBaseModel() {
        this.protocolID = 0;
        this.timeStamp = 0L;
        this.callbackId = 0;
        this.protocolVersion = Integer.toString(getModelVersion());
        this.packageName = "";
        this.var1 = "";
        this.clientPackageName = "";
    }

    @Override // android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getCallbackId() {
        return this.callbackId;
    }

    public String getClientPackageName() {
        return this.clientPackageName;
    }

    public final int getDataVersion() {
        int a = s90.a(this.protocolVersion, 0);
        int a2 = !TextUtils.isEmpty(this.clientPackageName) ? p80.a(this.clientPackageName, getClass().getSimpleName()) : -1;
        return (a2 >= 0 && a >= a2) ? a2 : a;
    }

    public int getModelVersion() {
        return 0;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getVar1() {
        return this.var1;
    }

    public void setCallbackId(int i) {
        this.callbackId = i;
    }

    public final void setClientPackageName(String str) {
        this.clientPackageName = str;
        for (Field field : getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object obj = field.get(this);
                if (obj != null) {
                    if (obj instanceof ProtocolBaseModel) {
                        ((ProtocolBaseModel) obj).setClientPackageName(str);
                    } else if (obj instanceof Collection) {
                        for (Object obj2 : (Collection) obj) {
                            if (obj2 instanceof ProtocolBaseModel) {
                                ((ProtocolBaseModel) obj2).setClientPackageName(str);
                            }
                        }
                    } else if (obj.getClass().isArray()) {
                        if (ProtocolBaseModel.class.isAssignableFrom(obj.getClass().getComponentType())) {
                            int i = 0;
                            while (true) {
                                Object[] objArr = (Object[]) obj;
                                if (i < objArr.length && (objArr[i] instanceof ProtocolBaseModel)) {
                                    ((ProtocolBaseModel) objArr[i]).setClientPackageName(str);
                                    i++;
                                }
                            }
                        }
                    } else if (obj instanceof Map) {
                        for (Object obj3 : ((Map) obj).values()) {
                            if (obj3 instanceof ProtocolBaseModel) {
                                ((ProtocolBaseModel) obj3).setClientPackageName(str);
                            }
                        }
                    }
                }
            } catch (IllegalAccessException e) {
                aa0.a("ProtocolBaseModel", "setDataVersion:", e);
            }
        }
    }

    public void setPackageName(String str) {
        this.packageName = str;
    }

    public void setProtocolID(int i) {
        this.protocolID = i;
    }

    public void setTimeStamp(long j) {
        this.timeStamp = j;
    }

    public void setVar1(String str) {
        this.var1 = str;
    }

    public JSONObject toJsonObject() {
        JSONObject jSONObject;
        try {
            jSONObject = gd.a(this);
            try {
                jSONObject.put("resultCode", 10000);
            } catch (Exception e) {
                e = e;
                aa0.a("ProtocolBaseModel", "toJsonObject failed!", e, new Object[0]);
                e.printStackTrace();
                return jSONObject;
            }
        } catch (Exception e2) {
            e = e2;
            jSONObject = null;
        }
        return jSONObject;
    }

    @Override // android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(this.protocolID);
        parcel.writeLong(this.timeStamp);
        parcel.writeInt(this.callbackId);
        parcel.writeString(Integer.toString(getDataVersion()));
        parcel.writeString(this.packageName);
        parcel.writeString(this.var1);
    }

    public ProtocolBaseModel(Parcel parcel) {
        this.protocolID = 0;
        this.timeStamp = 0L;
        this.callbackId = 0;
        this.protocolVersion = Integer.toString(getModelVersion());
        this.packageName = "";
        this.var1 = "";
        this.clientPackageName = "";
        this.protocolID = parcel.readInt();
        this.timeStamp = parcel.readLong();
        this.callbackId = parcel.readInt();
        this.protocolVersion = parcel.readString();
        this.packageName = parcel.readString();
        this.var1 = parcel.readString();
    }
}
