package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class CruisePlayTypeModel_JsonLubeParser implements Serializable {
    public static CruisePlayTypeModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        CruisePlayTypeModel cruisePlayTypeModel = new CruisePlayTypeModel(0);
        cruisePlayTypeModel.setClientPackageName(jSONObject.optString("clientPackageName", cruisePlayTypeModel.getClientPackageName()));
        cruisePlayTypeModel.setPackageName(jSONObject.optString("packageName", cruisePlayTypeModel.getPackageName()));
        cruisePlayTypeModel.setCallbackId(jSONObject.optInt("callbackId", cruisePlayTypeModel.getCallbackId()));
        cruisePlayTypeModel.setTimeStamp(jSONObject.optLong("timeStamp", cruisePlayTypeModel.getTimeStamp()));
        cruisePlayTypeModel.setVar1(jSONObject.optString("var1", cruisePlayTypeModel.getVar1()));
        cruisePlayTypeModel.setNaviCruiseType(jSONObject.optInt("naviCruiseType", cruisePlayTypeModel.getNaviCruiseType()));
        cruisePlayTypeModel.setIsSuccess(jSONObject.optInt("isSuccess", cruisePlayTypeModel.getIsSuccess()));
        cruisePlayTypeModel.setOperaType(jSONObject.optInt(StandardProtocolKey.EXTRA_OPERATYPE, cruisePlayTypeModel.getOperaType()));
        return cruisePlayTypeModel;
    }
}
