package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class MapOperaModel_JsonLubeParser implements Serializable {
    public static MapOperaModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        MapOperaModel mapOperaModel = new MapOperaModel(0, 0, 0);
        mapOperaModel.setClientPackageName(jSONObject.optString("clientPackageName", mapOperaModel.getClientPackageName()));
        mapOperaModel.setPackageName(jSONObject.optString("packageName", mapOperaModel.getPackageName()));
        mapOperaModel.setCallbackId(jSONObject.optInt("callbackId", mapOperaModel.getCallbackId()));
        mapOperaModel.setTimeStamp(jSONObject.optLong("timeStamp", mapOperaModel.getTimeStamp()));
        mapOperaModel.setVar1(jSONObject.optString("var1", mapOperaModel.getVar1()));
        mapOperaModel.setActionType(jSONObject.optInt("actionType", mapOperaModel.getActionType()));
        mapOperaModel.setOperaType(jSONObject.optInt(StandardProtocolKey.EXTRA_OPERATYPE, mapOperaModel.getOperaType()));
        mapOperaModel.setOperaValue(jSONObject.optInt("operaValue", mapOperaModel.getOperaValue()));
        mapOperaModel.setTempValue(jSONObject.optString("tempValue", mapOperaModel.getTempValue()));
        return mapOperaModel;
    }
}
