package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class MapOperaModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(MapOperaModel mapOperaModel) throws JSONException {
        if (mapOperaModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", mapOperaModel.getPackageName());
        jSONObject.put("clientPackageName", mapOperaModel.getClientPackageName());
        jSONObject.put("callbackId", mapOperaModel.getCallbackId());
        jSONObject.put("timeStamp", mapOperaModel.getTimeStamp());
        jSONObject.put("var1", mapOperaModel.getVar1());
        jSONObject.put("actionType", mapOperaModel.getActionType());
        jSONObject.put(StandardProtocolKey.EXTRA_OPERATYPE, mapOperaModel.getOperaType());
        jSONObject.put("operaValue", mapOperaModel.getOperaValue());
        jSONObject.put("tempValue", mapOperaModel.getTempValue());
        return jSONObject;
    }
}
