package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class NaviOperaModel_JsonLubeParser implements Serializable {
    public static NaviOperaModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        NaviOperaModel naviOperaModel = new NaviOperaModel(0, 0);
        naviOperaModel.setClientPackageName(jSONObject.optString("clientPackageName", naviOperaModel.getClientPackageName()));
        naviOperaModel.setPackageName(jSONObject.optString("packageName", naviOperaModel.getPackageName()));
        naviOperaModel.setCallbackId(jSONObject.optInt("callbackId", naviOperaModel.getCallbackId()));
        naviOperaModel.setTimeStamp(jSONObject.optLong("timeStamp", naviOperaModel.getTimeStamp()));
        naviOperaModel.setVar1(jSONObject.optString("var1", naviOperaModel.getVar1()));
        naviOperaModel.setJson(jSONObject.optString("json", naviOperaModel.getJson()));
        naviOperaModel.setActionType(jSONObject.optInt("actionType", naviOperaModel.getActionType()));
        naviOperaModel.setOperaType(jSONObject.optInt(StandardProtocolKey.EXTRA_OPERATYPE, naviOperaModel.getOperaType()));
        return naviOperaModel;
    }
}
