package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class NaviOperaModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(NaviOperaModel naviOperaModel) throws JSONException {
        if (naviOperaModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", naviOperaModel.getPackageName());
        jSONObject.put("clientPackageName", naviOperaModel.getClientPackageName());
        jSONObject.put("callbackId", naviOperaModel.getCallbackId());
        jSONObject.put("timeStamp", naviOperaModel.getTimeStamp());
        jSONObject.put("var1", naviOperaModel.getVar1());
        jSONObject.put("json", naviOperaModel.getJson());
        jSONObject.put("actionType", naviOperaModel.getActionType());
        jSONObject.put(StandardProtocolKey.EXTRA_OPERATYPE, naviOperaModel.getOperaType());
        return jSONObject;
    }
}
