package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class PageJumpModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<PageJumpModel> CREATOR = new a();
    public static final int JUMP_AROUND_SEARCH = 6;
    public static final int JUMP_COMPANY = 8;
    public static final int JUMP_DOWLOAD_MAPDATA = 11;
    public static final int JUMP_EDIT_ROUTE_PAGE = 15;
    public static final int JUMP_FAVORITE = 9;
    public static final int JUMP_GO_HOME_OR_COMPANY_PNAV_PAGE = 14;
    public static final int JUMP_HOME = 7;
    public static final int JUMP_MY_TRIP = 5;
    public static final int JUMP_NAVIGATION_ENTER_IMMERSION = 13;
    public static final int JUMP_PARKING_PAY = 3;
    public static final int JUMP_SEARCH = 1;
    public static final int JUMP_SEARCH_MORE = 0;
    public static final int JUMP_SECOND_SCREEN = 18;
    public static final int JUMP_SETTING = 2;
    public static final int JUMP_SET_HOME_OR_COMPANY = 10;
    public static final int JUMP_TEAM = 4;
    public static final int JUMP_UDISK = 12;
    public int displayID;

    @o60(isMustFill = true, maxValue = 19, minValue = 0)
    public int pageType;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<PageJumpModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public PageJumpModel createFromParcel(Parcel parcel) {
            return new PageJumpModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public PageJumpModel[] newArray(int i) {
            return new PageJumpModel[i];
        }
    }

    public PageJumpModel() {
        this.pageType = -1;
        setProtocolID(30306);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getDisplayID() {
        return this.displayID;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 1;
    }

    public int getPageType() {
        return this.pageType;
    }

    public void setDisplayID(int i) {
        this.displayID = i;
    }

    public void setPageType(int i) {
        this.pageType = i;
    }

    public String toString() {
        return "PageJumpModel{pageType=" + this.pageType + ", displayID=" + this.displayID + '}';
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.pageType);
        if (getModelVersion() >= 1) {
            parcel.writeInt(this.displayID);
        }
    }

    public PageJumpModel(Parcel parcel) {
        super(parcel);
        this.pageType = -1;
        this.pageType = parcel.readInt();
        if (getModelVersion() >= 1) {
            this.displayID = parcel.readInt();
        }
    }
}
