package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ParkOperaModel_JsonLubeParser implements Serializable {
    public static ParkOperaModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ParkOperaModel parkOperaModel = new ParkOperaModel();
        parkOperaModel.setClientPackageName(jSONObject.optString("clientPackageName", parkOperaModel.getClientPackageName()));
        parkOperaModel.setPackageName(jSONObject.optString("packageName", parkOperaModel.getPackageName()));
        parkOperaModel.setCallbackId(jSONObject.optInt("callbackId", parkOperaModel.getCallbackId()));
        parkOperaModel.setTimeStamp(jSONObject.optLong("timeStamp", parkOperaModel.getTimeStamp()));
        parkOperaModel.setVar1(jSONObject.optString("var1", parkOperaModel.getVar1()));
        parkOperaModel.setOperaSelect(jSONObject.optInt(StandardProtocolKey.EXTRA_OPERASELECT, parkOperaModel.getOperaSelect()));
        return parkOperaModel;
    }
}
