package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class ReqARHudVirtualImageParamModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ReqARHudVirtualImageParamModel> CREATOR = new a();
    public double eyeX;
    public double eyeY;
    public double eyeZ;
    public double fovH;
    public double fovW;
    public double heading;
    public double pitch;
    public int pixelH;
    public int pixelW;
    public double roll;
    public double vid;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ReqARHudVirtualImageParamModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqARHudVirtualImageParamModel createFromParcel(Parcel parcel) {
            return new ReqARHudVirtualImageParamModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqARHudVirtualImageParamModel[] newArray(int i) {
            return new ReqARHudVirtualImageParamModel[i];
        }
    }

    public ReqARHudVirtualImageParamModel() {
        this.pixelH = 0;
        this.pixelW = 0;
        setProtocolID(80184);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public double getEyeX() {
        return this.eyeX;
    }

    public double getEyeY() {
        return this.eyeY;
    }

    public double getEyeZ() {
        return this.eyeZ;
    }

    public double getFovH() {
        return this.fovH;
    }

    public double getFovW() {
        return this.fovW;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getPitch() {
        return this.pitch;
    }

    public int getPixelH() {
        return this.pixelH;
    }

    public int getPixelW() {
        return this.pixelW;
    }

    public double getRoll() {
        return this.roll;
    }

    public double getVid() {
        return this.vid;
    }

    public void setEyeX(double d) {
        this.eyeX = d;
    }

    public void setEyeY(double d) {
        this.eyeY = d;
    }

    public void setEyeZ(double d) {
        this.eyeZ = d;
    }

    public void setFovH(double d) {
        this.fovH = d;
    }

    public void setFovW(double d) {
        this.fovW = d;
    }

    public void setHeading(double d) {
        this.heading = d;
    }

    public void setPitch(double d) {
        this.pitch = d;
    }

    public void setPixelH(int i) {
        this.pixelH = i;
    }

    public void setPixelW(int i) {
        this.pixelW = i;
    }

    public void setRoll(double d) {
        this.roll = d;
    }

    public void setVid(double d) {
        this.vid = d;
    }

    public String toString() {
        return "eyeX: " + this.eyeX + "\neyeY: " + this.eyeY + "\neyeZ: " + this.eyeZ + "\nfovH: " + this.fovH + "\nfovW: " + this.fovW + "\nheading: " + this.heading + "\npitch: " + this.pitch + "\npixelH: " + this.pixelH + "\npixelW: " + this.pixelW + "\nroll: " + this.roll + "\nvid: " + this.vid + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeDouble(this.eyeX);
        parcel.writeDouble(this.eyeY);
        parcel.writeDouble(this.eyeZ);
        parcel.writeDouble(this.fovH);
        parcel.writeDouble(this.fovW);
        parcel.writeDouble(this.heading);
        parcel.writeDouble(this.pitch);
        parcel.writeInt(this.pixelH);
        parcel.writeInt(this.pixelW);
        parcel.writeDouble(this.roll);
        parcel.writeDouble(this.vid);
    }

    public ReqARHudVirtualImageParamModel(Parcel parcel) {
        super(parcel);
        this.pixelH = 0;
        this.pixelW = 0;
        this.eyeX = parcel.readDouble();
        this.eyeY = parcel.readDouble();
        this.eyeZ = parcel.readDouble();
        this.fovH = parcel.readDouble();
        this.fovW = parcel.readDouble();
        this.heading = parcel.readDouble();
        this.pitch = parcel.readDouble();
        this.pixelH = parcel.readInt();
        this.pixelW = parcel.readInt();
        this.roll = parcel.readDouble();
        this.vid = parcel.readDouble();
    }
}
