package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class ReqArNavigationLDWInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ReqArNavigationLDWInfoModel> CREATOR = new a();
    public int lane;
    public double laneDistanceFusion;

    @o60(isLonLat = true)
    public int laneLineViolation;
    public int laneMarkerType;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ReqArNavigationLDWInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqArNavigationLDWInfoModel createFromParcel(Parcel parcel) {
            return new ReqArNavigationLDWInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqArNavigationLDWInfoModel[] newArray(int i) {
            return new ReqArNavigationLDWInfoModel[i];
        }
    }

    public ReqArNavigationLDWInfoModel() {
        setProtocolID(80123);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getLane() {
        return this.lane;
    }

    public double getLaneDistanceFusion() {
        return this.laneDistanceFusion;
    }

    public int getLaneLineViolation() {
        return this.laneLineViolation;
    }

    public int getLaneMarkerType() {
        return this.laneMarkerType;
    }

    public void setLane(int i) {
        this.lane = i;
    }

    public void setLaneDistanceFusion(double d) {
        this.laneDistanceFusion = d;
    }

    public void setLaneLineViolation(int i) {
        this.laneLineViolation = i;
    }

    public void setLaneMarkerType(int i) {
        this.laneMarkerType = i;
    }

    public String toString() {
        return StandardProtocolKey.EXTRA_LANE + ": " + this.lane + "\n" + StandardProtocolKey.EXTRA_LANEDISTANCEFUSION + ": " + this.laneDistanceFusion + "\n" + StandardProtocolKey.EXTRA_LANELINEVIOLATION + ": " + this.laneLineViolation + "\n" + StandardProtocolKey.EXTRA_LANEMARKERTYPE + ": " + this.laneMarkerType + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.lane);
        parcel.writeDouble(this.laneDistanceFusion);
        parcel.writeInt(this.laneLineViolation);
        parcel.writeInt(this.laneMarkerType);
    }

    public ReqArNavigationLDWInfoModel(Parcel parcel) {
        super(parcel);
        this.lane = parcel.readInt();
        this.laneDistanceFusion = parcel.readDouble();
        this.laneLineViolation = parcel.readInt();
        this.laneMarkerType = parcel.readInt();
    }
}
