package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class ReqBringAutoToForegroundModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ReqBringAutoToForegroundModel> CREATOR = new a();
    public int displayID;
    public int requestType;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ReqBringAutoToForegroundModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqBringAutoToForegroundModel createFromParcel(Parcel parcel) {
            return new ReqBringAutoToForegroundModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqBringAutoToForegroundModel[] newArray(int i) {
            return new ReqBringAutoToForegroundModel[i];
        }
    }

    public ReqBringAutoToForegroundModel() {
        this.requestType = 0;
        this.displayID = 0;
        setProtocolID(80132);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getDisplayID() {
        return this.displayID;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 2;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setDisplayID(int i) {
        this.displayID = i;
    }

    public void setRequestType(int i) {
        this.requestType = i;
    }

    public String toString() {
        return StandardProtocolKey.EXTRA_REQUESTTYPE + ": " + this.requestType + "\ndisplayID: " + this.displayID + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        if (getDataVersion() >= 1) {
            parcel.writeInt(this.requestType);
        }
        if (getDataVersion() >= 2) {
            parcel.writeInt(this.displayID);
        }
    }

    public ReqBringAutoToForegroundModel(Parcel parcel) {
        super(parcel);
        this.requestType = 0;
        this.displayID = 0;
        if (getDataVersion() >= 1) {
            this.requestType = parcel.readInt();
        }
        if (getDataVersion() >= 2) {
            this.displayID = parcel.readInt();
        }
    }
}
