package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class ReqCarPlateInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ReqCarPlateInfoModel> CREATOR = new a();

    @o60(isLonLat = true)
    public String carPlateNumber;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ReqCarPlateInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqCarPlateInfoModel createFromParcel(Parcel parcel) {
            return new ReqCarPlateInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqCarPlateInfoModel[] newArray(int i) {
            return new ReqCarPlateInfoModel[i];
        }
    }

    public ReqCarPlateInfoModel() {
        setProtocolID(80104);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getCarPlateNumber() {
        return this.carPlateNumber;
    }

    public void setCarPlateNumber(String str) {
        this.carPlateNumber = str;
    }

    public String toString() {
        return StandardProtocolKey.EXTRA_CARPLATENUMBER + ": " + this.carPlateNumber + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.carPlateNumber);
    }

    public ReqCarPlateInfoModel(String str) {
        setProtocolID(80104);
        this.carPlateNumber = str;
    }

    public ReqCarPlateInfoModel(Parcel parcel) {
        super(parcel);
        this.carPlateNumber = parcel.readString();
    }
}
