package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class ReqTrafficRestrictQueryModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ReqTrafficRestrictQueryModel> CREATOR = new a();
    public String carPlateNumber;
    public String date;

    @o60(isLonLat = true)
    public double lat;

    @o60(isLonLat = true)
    public double lon;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ReqTrafficRestrictQueryModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqTrafficRestrictQueryModel createFromParcel(Parcel parcel) {
            return new ReqTrafficRestrictQueryModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqTrafficRestrictQueryModel[] newArray(int i) {
            return new ReqTrafficRestrictQueryModel[i];
        }
    }

    public ReqTrafficRestrictQueryModel() {
        setProtocolID(80097);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getCarPlateNumber() {
        return this.carPlateNumber;
    }

    public String getDate() {
        return this.date;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setCarPlateNumber(String str) {
        this.carPlateNumber = str;
    }

    public void setDate(String str) {
        this.date = str;
    }

    public void setLat(double d) {
        this.lat = d;
    }

    public void setLon(double d) {
        this.lon = d;
    }

    public String toString() {
        return StandardProtocolKey.EXTRA_CARPLATENUMBER + ": " + this.carPlateNumber + "\ndate: " + this.date + "\n" + LocationParams.PARA_FLP_AUTONAVI_LAT + ": " + this.lat + "\n" + LocationParams.PARA_FLP_AUTONAVI_LON + ": " + this.lon + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.carPlateNumber);
        parcel.writeString(this.date);
        parcel.writeDouble(this.lat);
        parcel.writeDouble(this.lon);
    }

    public ReqTrafficRestrictQueryModel(String str, String str2, double d, double d2) {
        setProtocolID(80097);
        this.carPlateNumber = str;
        this.date = str2;
        this.lat = d;
        this.lon = d2;
    }

    public ReqTrafficRestrictQueryModel(Parcel parcel) {
        super(parcel);
        this.carPlateNumber = parcel.readString();
        this.date = parcel.readString();
        this.lat = parcel.readDouble();
        this.lon = parcel.readDouble();
    }
}
