package com.autonavi.amapauto.protocol.model.client;

import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ReqTrafficRestrictQueryModel_JsonLubeParser implements Serializable {
    public static ReqTrafficRestrictQueryModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ReqTrafficRestrictQueryModel reqTrafficRestrictQueryModel = new ReqTrafficRestrictQueryModel();
        reqTrafficRestrictQueryModel.setClientPackageName(jSONObject.optString("clientPackageName", reqTrafficRestrictQueryModel.getClientPackageName()));
        reqTrafficRestrictQueryModel.setPackageName(jSONObject.optString("packageName", reqTrafficRestrictQueryModel.getPackageName()));
        reqTrafficRestrictQueryModel.setCallbackId(jSONObject.optInt("callbackId", reqTrafficRestrictQueryModel.getCallbackId()));
        reqTrafficRestrictQueryModel.setTimeStamp(jSONObject.optLong("timeStamp", reqTrafficRestrictQueryModel.getTimeStamp()));
        reqTrafficRestrictQueryModel.setVar1(jSONObject.optString("var1", reqTrafficRestrictQueryModel.getVar1()));
        reqTrafficRestrictQueryModel.setCarPlateNumber(jSONObject.optString(StandardProtocolKey.EXTRA_CARPLATENUMBER, reqTrafficRestrictQueryModel.getCarPlateNumber()));
        reqTrafficRestrictQueryModel.setDate(jSONObject.optString("date", reqTrafficRestrictQueryModel.getDate()));
        reqTrafficRestrictQueryModel.setLat(jSONObject.optDouble(LocationParams.PARA_FLP_AUTONAVI_LAT, reqTrafficRestrictQueryModel.getLat()));
        reqTrafficRestrictQueryModel.setLon(jSONObject.optDouble(LocationParams.PARA_FLP_AUTONAVI_LON, reqTrafficRestrictQueryModel.getLon()));
        return reqTrafficRestrictQueryModel;
    }
}
