package com.autonavi.amapauto.protocol.model.client;

import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ReqTrafficRestrictQueryModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ReqTrafficRestrictQueryModel reqTrafficRestrictQueryModel) throws JSONException {
        if (reqTrafficRestrictQueryModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", reqTrafficRestrictQueryModel.getPackageName());
        jSONObject.put("clientPackageName", reqTrafficRestrictQueryModel.getClientPackageName());
        jSONObject.put("callbackId", reqTrafficRestrictQueryModel.getCallbackId());
        jSONObject.put("timeStamp", reqTrafficRestrictQueryModel.getTimeStamp());
        jSONObject.put("var1", reqTrafficRestrictQueryModel.getVar1());
        jSONObject.put(StandardProtocolKey.EXTRA_CARPLATENUMBER, reqTrafficRestrictQueryModel.getCarPlateNumber());
        jSONObject.put("date", reqTrafficRestrictQueryModel.getDate());
        jSONObject.put(LocationParams.PARA_FLP_AUTONAVI_LAT, reqTrafficRestrictQueryModel.getLat());
        jSONObject.put(LocationParams.PARA_FLP_AUTONAVI_LON, reqTrafficRestrictQueryModel.getLon());
        return jSONObject;
    }
}
