package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.item.ProtocolPoi;
import defpackage.o60;
import java.util.List;

@Keep
/* loaded from: classes.dex */
public class RequestRouteExModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RequestRouteExModel> CREATOR = new a();

    @o60(maxValue = 2, minValue = 0)
    public int actionType;

    @o60(maxValue = 1, minValue = 0)
    public int dev;

    @o60(isMustFill = true)
    public ProtocolPoi endProtocolPoi;
    public String json;
    public List<ProtocolPoi> midProtocolPois;
    public int newStrategy;
    public ProtocolPoi startProtocolPoi;

    @o60(intValues = {1, 2, 3, 4, 5, 6, 7, 8, 20, 24, -1})
    public int strategy;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RequestRouteExModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RequestRouteExModel createFromParcel(Parcel parcel) {
            return new RequestRouteExModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RequestRouteExModel[] newArray(int i) {
            return new RequestRouteExModel[i];
        }
    }

    public RequestRouteExModel() {
        this.actionType = 1;
        this.strategy = -1;
        this.dev = 0;
        this.newStrategy = -100;
        setProtocolID(30402);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getActionType() {
        return this.actionType;
    }

    public int getDev() {
        return this.dev;
    }

    public ProtocolPoi getEndProtocolPoi() {
        return this.endProtocolPoi;
    }

    public String getJson() {
        return this.json;
    }

    public List<ProtocolPoi> getMidProtocolPois() {
        return this.midProtocolPois;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 2;
    }

    public int getNewStrategy() {
        return this.newStrategy;
    }

    public ProtocolPoi getStartProtocolPoi() {
        return this.startProtocolPoi;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public void setActionType(int i) {
        this.actionType = i;
    }

    public void setDev(int i) {
        this.dev = i;
    }

    public void setEndProtocolPoi(ProtocolPoi protocolPoi) {
        this.endProtocolPoi = protocolPoi;
    }

    public void setJson(String str) {
        this.json = str;
    }

    public void setMidProtocolPois(List<ProtocolPoi> list) {
        this.midProtocolPois = list;
    }

    public void setNewStrategy(int i) {
        this.newStrategy = i;
    }

    public void setStartProtocolPoi(ProtocolPoi protocolPoi) {
        this.startProtocolPoi = protocolPoi;
    }

    public void setStrategy(int i) {
        this.strategy = i;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.actionType);
        parcel.writeInt(this.strategy);
        parcel.writeInt(this.dev);
        parcel.writeParcelable(this.endProtocolPoi, i);
        parcel.writeTypedList(this.midProtocolPois);
        parcel.writeString(this.json);
        if (getDataVersion() >= 1) {
            parcel.writeParcelable(this.startProtocolPoi, i);
        }
        if (getDataVersion() >= 2) {
            parcel.writeInt(this.newStrategy);
        }
    }

    public RequestRouteExModel(Parcel parcel) {
        super(parcel);
        this.actionType = 1;
        this.strategy = -1;
        this.dev = 0;
        this.newStrategy = -100;
        this.actionType = parcel.readInt();
        this.strategy = parcel.readInt();
        this.dev = parcel.readInt();
        this.endProtocolPoi = (ProtocolPoi) parcel.readParcelable(ProtocolPoi.class.getClassLoader());
        this.midProtocolPois = parcel.createTypedArrayList(ProtocolPoi.CREATOR);
        this.json = parcel.readString();
        if (getDataVersion() >= 1) {
            this.startProtocolPoi = (ProtocolPoi) parcel.readParcelable(ProtocolPoi.class.getClassLoader());
        }
        if (getDataVersion() >= 2) {
            this.newStrategy = parcel.readInt();
        }
    }
}
