package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.model.item.ProtocolPoi_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RequestRouteExModel_JsonLubeParser implements Serializable {
    public static RequestRouteExModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RequestRouteExModel requestRouteExModel = new RequestRouteExModel();
        requestRouteExModel.setClientPackageName(jSONObject.optString("clientPackageName", requestRouteExModel.getClientPackageName()));
        requestRouteExModel.setPackageName(jSONObject.optString("packageName", requestRouteExModel.getPackageName()));
        requestRouteExModel.setCallbackId(jSONObject.optInt("callbackId", requestRouteExModel.getCallbackId()));
        requestRouteExModel.setTimeStamp(jSONObject.optLong("timeStamp", requestRouteExModel.getTimeStamp()));
        requestRouteExModel.setVar1(jSONObject.optString("var1", requestRouteExModel.getVar1()));
        requestRouteExModel.setActionType(jSONObject.optInt("actionType", requestRouteExModel.getActionType()));
        requestRouteExModel.setStrategy(jSONObject.optInt("strategy", requestRouteExModel.getStrategy()));
        requestRouteExModel.setDev(jSONObject.optInt("dev", requestRouteExModel.getDev()));
        requestRouteExModel.setStartProtocolPoi(ProtocolPoi_JsonLubeParser.parse(jSONObject.optJSONObject("startProtocolPoi")));
        requestRouteExModel.setEndProtocolPoi(ProtocolPoi_JsonLubeParser.parse(jSONObject.optJSONObject("endProtocolPoi")));
        JSONArray optJSONArray = jSONObject.optJSONArray("midProtocolPois");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList arrayList = new ArrayList(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(ProtocolPoi_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            requestRouteExModel.setMidProtocolPois(arrayList);
        }
        requestRouteExModel.setNewStrategy(jSONObject.optInt("newStrategy", requestRouteExModel.getNewStrategy()));
        requestRouteExModel.setJson(jSONObject.optString("json", requestRouteExModel.getJson()));
        return requestRouteExModel;
    }
}
