package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.model.item.ProtocolPoi;
import com.autonavi.amapauto.protocol.model.item.ProtocolPoi_JsonLubeSerializer;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RequestRouteExModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RequestRouteExModel requestRouteExModel) throws JSONException {
        if (requestRouteExModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", requestRouteExModel.getPackageName());
        jSONObject.put("clientPackageName", requestRouteExModel.getClientPackageName());
        jSONObject.put("callbackId", requestRouteExModel.getCallbackId());
        jSONObject.put("timeStamp", requestRouteExModel.getTimeStamp());
        jSONObject.put("var1", requestRouteExModel.getVar1());
        jSONObject.put("actionType", requestRouteExModel.getActionType());
        jSONObject.put("strategy", requestRouteExModel.getStrategy());
        jSONObject.put("dev", requestRouteExModel.getDev());
        jSONObject.put("startProtocolPoi", ProtocolPoi_JsonLubeSerializer.serialize(requestRouteExModel.getStartProtocolPoi()));
        jSONObject.put("endProtocolPoi", ProtocolPoi_JsonLubeSerializer.serialize(requestRouteExModel.getEndProtocolPoi()));
        if (requestRouteExModel.getMidProtocolPois() != null) {
            JSONArray jSONArray = new JSONArray();
            for (ProtocolPoi protocolPoi : requestRouteExModel.getMidProtocolPois()) {
                if (protocolPoi != null) {
                    jSONArray.put(ProtocolPoi_JsonLubeSerializer.serialize(protocolPoi));
                }
            }
            jSONObject.put("midProtocolPois", jSONArray);
        }
        jSONObject.put("newStrategy", requestRouteExModel.getNewStrategy());
        jSONObject.put("json", requestRouteExModel.getJson());
        return jSONObject;
    }
}
