package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.item.SteeringWheelData;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class ResponseCarHWStatusModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ResponseCarHWStatusModel> CREATOR = new a();

    @o60(isMustFill = true, maxValue = 4, minValue = 0)
    public int gear;

    @o60(isMustFill = true)
    public SteeringWheelData steeringWheel;

    @o60(isMustFill = true, maxValue = 3, minValue = 0)
    public int turnLight;

    @o60(isMustFill = true, maxValue = 3, minValue = 0)
    public int wipeState;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ResponseCarHWStatusModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ResponseCarHWStatusModel createFromParcel(Parcel parcel) {
            return new ResponseCarHWStatusModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ResponseCarHWStatusModel[] newArray(int i) {
            return new ResponseCarHWStatusModel[i];
        }
    }

    public ResponseCarHWStatusModel() {
        setProtocolID(30607);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getGear() {
        return this.gear;
    }

    public SteeringWheelData getSteeringWheel() {
        return this.steeringWheel;
    }

    public int getTurnLight() {
        return this.turnLight;
    }

    public int getWipeState() {
        return this.wipeState;
    }

    public void setGear(int i) {
        this.gear = i;
    }

    public void setSteeringWheel(SteeringWheelData steeringWheelData) {
        this.steeringWheel = steeringWheelData;
    }

    public void setTurnLight(int i) {
        this.turnLight = i;
    }

    public void setWipeState(int i) {
        this.wipeState = i;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.wipeState);
        parcel.writeInt(this.gear);
        parcel.writeInt(this.turnLight);
        parcel.writeParcelable(this.steeringWheel, i);
    }

    public ResponseCarHWStatusModel(Parcel parcel) {
        super(parcel);
        this.wipeState = parcel.readInt();
        this.gear = parcel.readInt();
        this.turnLight = parcel.readInt();
        this.steeringWheel = (SteeringWheelData) parcel.readParcelable(SteeringWheelData.class.getClassLoader());
    }
}
