package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspArCameraIdModel_JsonLubeParser implements Serializable {
    public static RspArCameraIdModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RspArCameraIdModel rspArCameraIdModel = new RspArCameraIdModel();
        rspArCameraIdModel.setClientPackageName(jSONObject.optString("clientPackageName", rspArCameraIdModel.getClientPackageName()));
        rspArCameraIdModel.setPackageName(jSONObject.optString("packageName", rspArCameraIdModel.getPackageName()));
        rspArCameraIdModel.setCallbackId(jSONObject.optInt("callbackId", rspArCameraIdModel.getCallbackId()));
        rspArCameraIdModel.setTimeStamp(jSONObject.optLong("timeStamp", rspArCameraIdModel.getTimeStamp()));
        rspArCameraIdModel.setVar1(jSONObject.optString("var1", rspArCameraIdModel.getVar1()));
        rspArCameraIdModel.setCameraDisplay(jSONObject.optString(StandardProtocolKey.EXTRA_CAMERA_DISPLAY, rspArCameraIdModel.getCameraDisplay()));
        rspArCameraIdModel.setProductModel(jSONObject.optString(StandardProtocolKey.EXTRA_PRODUCT_MODEL, rspArCameraIdModel.getProductModel()));
        rspArCameraIdModel.setCameraName(jSONObject.optString(StandardProtocolKey.EXTRA_CAMERA_NAME, rspArCameraIdModel.getCameraName()));
        rspArCameraIdModel.setProductName(jSONObject.optString(StandardProtocolKey.EXTRA_PRODUCT_NAME, rspArCameraIdModel.getProductName()));
        rspArCameraIdModel.setImu(jSONObject.optString(StandardProtocolKey.EXTRA_IMU, rspArCameraIdModel.getImu()));
        rspArCameraIdModel.setCameraConnect(jSONObject.optString(StandardProtocolKey.EXTRA_CAMERA_CONNECT, rspArCameraIdModel.getCameraConnect()));
        rspArCameraIdModel.setApkName(jSONObject.optString(StandardProtocolKey.EXTRA_APK_NAME, rspArCameraIdModel.getApkName()));
        rspArCameraIdModel.setServiceAction(jSONObject.optString(StandardProtocolKey.EXTRA_SERVICE_ACTION, rspArCameraIdModel.getServiceAction()));
        rspArCameraIdModel.setCommon(jSONObject.optBoolean(StandardProtocolKey.EXTRA_COMMON, rspArCameraIdModel.isCommon()));
        return rspArCameraIdModel;
    }
}
