package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspArCameraIdModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RspArCameraIdModel rspArCameraIdModel) throws JSONException {
        if (rspArCameraIdModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", rspArCameraIdModel.getPackageName());
        jSONObject.put("clientPackageName", rspArCameraIdModel.getClientPackageName());
        jSONObject.put("callbackId", rspArCameraIdModel.getCallbackId());
        jSONObject.put("timeStamp", rspArCameraIdModel.getTimeStamp());
        jSONObject.put("var1", rspArCameraIdModel.getVar1());
        jSONObject.put(StandardProtocolKey.EXTRA_CAMERA_DISPLAY, rspArCameraIdModel.getCameraDisplay());
        jSONObject.put(StandardProtocolKey.EXTRA_PRODUCT_MODEL, rspArCameraIdModel.getProductModel());
        jSONObject.put(StandardProtocolKey.EXTRA_CAMERA_NAME, rspArCameraIdModel.getCameraName());
        jSONObject.put(StandardProtocolKey.EXTRA_PRODUCT_NAME, rspArCameraIdModel.getProductName());
        jSONObject.put(StandardProtocolKey.EXTRA_IMU, rspArCameraIdModel.getImu());
        jSONObject.put(StandardProtocolKey.EXTRA_CAMERA_CONNECT, rspArCameraIdModel.getCameraConnect());
        jSONObject.put(StandardProtocolKey.EXTRA_APK_NAME, rspArCameraIdModel.getApkName());
        jSONObject.put(StandardProtocolKey.EXTRA_SERVICE_ACTION, rspArCameraIdModel.getServiceAction());
        jSONObject.put(StandardProtocolKey.EXTRA_COMMON, rspArCameraIdModel.isCommon());
        return jSONObject;
    }
}
