package com.autonavi.amapauto.protocol.model.client;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.item.PowertrainLossInfo;
import defpackage.o60;
import java.util.ArrayList;

@Keep
/* loaded from: classes.dex */
public class RspCarEnergyInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspCarEnergyInfoModel> CREATOR = new a();
    public double auxCost;

    @o60(intValues = {0, 1, 2, 3, 4, 5, 6, 7, 8})
    public int curDriveMode;
    public ArrayList<Double> curveCostlist;
    public int energyUnit;
    public double ferryrateCost;
    public double initialHvBattenergy;
    public boolean isCharge;
    public int lowEnergyAlert;
    public int lowEnergyWarn;
    public double maxBattEnergy;
    public double percentOfResidualEnergy;
    public ArrayList<PowertrainLossInfo> powertrainLoss;
    public int rangeDist;
    public ArrayList<Double> slopeCostlist;
    public ArrayList<Double> speedCostlist;
    public int topSpeed;
    public ArrayList<Double> transCostlist;
    public int vehicleWeight;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspCarEnergyInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspCarEnergyInfoModel createFromParcel(Parcel parcel) {
            return new RspCarEnergyInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspCarEnergyInfoModel[] newArray(int i) {
            return new RspCarEnergyInfoModel[i];
        }
    }

    public RspCarEnergyInfoModel() {
        setProtocolID(80038);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public double getAuxCost() {
        return this.auxCost;
    }

    public int getCurDriveMode() {
        return this.curDriveMode;
    }

    public ArrayList<Double> getCurveCostlist() {
        return this.curveCostlist;
    }

    public int getEnergyUnit() {
        return this.energyUnit;
    }

    public double getFerryrateCost() {
        return this.ferryrateCost;
    }

    public double getInitialHvBattenergy() {
        return this.initialHvBattenergy;
    }

    public boolean getIsCharge() {
        return this.isCharge;
    }

    public int getLowEnergyAlert() {
        return this.lowEnergyAlert;
    }

    public int getLowEnergyWarn() {
        return this.lowEnergyWarn;
    }

    public double getMaxBattEnergy() {
        return this.maxBattEnergy;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 1;
    }

    public double getPercentOfResidualEnergy() {
        return this.percentOfResidualEnergy;
    }

    public ArrayList<PowertrainLossInfo> getPowertrainLoss() {
        return this.powertrainLoss;
    }

    public int getRangeDist() {
        return this.rangeDist;
    }

    public ArrayList<Double> getSlopeCostlist() {
        return this.slopeCostlist;
    }

    public ArrayList<Double> getSpeedCostlist() {
        return this.speedCostlist;
    }

    public int getTopSpeed() {
        return this.topSpeed;
    }

    public ArrayList<Double> getTransCostlist() {
        return this.transCostlist;
    }

    public int getVehicleWeight() {
        return this.vehicleWeight;
    }

    public void setAuxCost(double d) {
        this.auxCost = d;
    }

    public void setCurDriveMode(int i) {
        this.curDriveMode = i;
    }

    public void setCurveCostlist(ArrayList<Double> arrayList) {
        this.curveCostlist = arrayList;
    }

    public void setEnergyUnit(int i) {
        this.energyUnit = i;
    }

    public void setFerryrateCost(double d) {
        this.ferryrateCost = d;
    }

    public void setInitialHvBattenergy(double d) {
        this.initialHvBattenergy = d;
    }

    public void setIsCharge(boolean z) {
        this.isCharge = z;
    }

    public void setLowEnergyAlert(int i) {
        this.lowEnergyAlert = i;
    }

    public void setLowEnergyWarn(int i) {
        this.lowEnergyWarn = i;
    }

    public void setMaxBattEnergy(double d) {
        this.maxBattEnergy = d;
    }

    public void setPercentOfResidualEnergy(double d) {
        this.percentOfResidualEnergy = d;
    }

    public void setPowertrainLoss(ArrayList<PowertrainLossInfo> arrayList) {
        this.powertrainLoss = arrayList;
    }

    public void setRangeDist(int i) {
        this.rangeDist = i;
    }

    public void setSlopeCostlist(ArrayList<Double> arrayList) {
        this.slopeCostlist = arrayList;
    }

    public void setSpeedCostlist(ArrayList<Double> arrayList) {
        this.speedCostlist = arrayList;
    }

    public void setTopSpeed(int i) {
        this.topSpeed = i;
    }

    public void setTransCostlist(ArrayList<Double> arrayList) {
        this.transCostlist = arrayList;
    }

    public void setVehicleWeight(int i) {
        this.vehicleWeight = i;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("auxCost");
        sb.append(": ");
        sb.append(this.auxCost);
        sb.append("\n");
        sb.append("curDriveMode");
        sb.append(": ");
        sb.append(this.curDriveMode);
        sb.append("\n");
        sb.append("curveCostlist");
        sb.append(": ");
        ArrayList<Double> arrayList = this.curveCostlist;
        sb.append(arrayList != null ? arrayList.toString() : "null");
        sb.append("\n");
        sb.append("energyUnit");
        sb.append(": ");
        sb.append(this.energyUnit);
        sb.append("\n");
        sb.append("ferryrateCost");
        sb.append(": ");
        sb.append(this.ferryrateCost);
        sb.append("\n");
        sb.append("initialHvBattenergy");
        sb.append(": ");
        sb.append(this.initialHvBattenergy);
        sb.append("\n");
        sb.append("isCharge");
        sb.append(": ");
        sb.append(this.isCharge);
        sb.append("\n");
        sb.append("lowEnergyAlert");
        sb.append(": ");
        sb.append(this.lowEnergyAlert);
        sb.append("\n");
        sb.append("lowEnergyWarn");
        sb.append(": ");
        sb.append(this.lowEnergyWarn);
        sb.append("\n");
        sb.append("maxBattEnergy");
        sb.append(": ");
        sb.append(this.maxBattEnergy);
        sb.append("\n");
        sb.append(StandardProtocolKey.EXTRA_PERCENT_OF_RESIDUAL_ENERGY);
        sb.append(": ");
        sb.append(this.percentOfResidualEnergy);
        sb.append("\n");
        sb.append("powertrainLoss");
        sb.append(": ");
        ArrayList<PowertrainLossInfo> arrayList2 = this.powertrainLoss;
        sb.append(arrayList2 != null ? arrayList2.toString() : "null");
        sb.append("\n");
        sb.append("rangeDist");
        sb.append(": ");
        sb.append(this.rangeDist);
        sb.append("\n");
        sb.append("slopeCostlist");
        sb.append(": ");
        ArrayList<Double> arrayList3 = this.slopeCostlist;
        sb.append(arrayList3 != null ? arrayList3.toString() : "null");
        sb.append("\n");
        sb.append("speedCostlist");
        sb.append(": ");
        ArrayList<Double> arrayList4 = this.speedCostlist;
        sb.append(arrayList4 != null ? arrayList4.toString() : "null");
        sb.append("\n");
        sb.append("topSpeed");
        sb.append(": ");
        sb.append(this.topSpeed);
        sb.append("\n");
        sb.append("transCostlist");
        sb.append(": ");
        ArrayList<Double> arrayList5 = this.transCostlist;
        sb.append(arrayList5 != null ? arrayList5.toString() : "null");
        sb.append("\n");
        sb.append("vehicleWeight");
        sb.append(": ");
        sb.append(this.vehicleWeight);
        sb.append("\n");
        return sb.toString();
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeDouble(this.auxCost);
        parcel.writeInt(this.curDriveMode);
        parcel.writeList(this.curveCostlist);
        parcel.writeInt(this.energyUnit);
        parcel.writeDouble(this.ferryrateCost);
        parcel.writeDouble(this.initialHvBattenergy);
        parcel.writeByte(this.isCharge ? (byte) 1 : (byte) 0);
        parcel.writeInt(this.lowEnergyAlert);
        parcel.writeInt(this.lowEnergyWarn);
        parcel.writeDouble(this.maxBattEnergy);
        parcel.writeDouble(this.percentOfResidualEnergy);
        parcel.writeInt(this.rangeDist);
        parcel.writeList(this.slopeCostlist);
        parcel.writeList(this.speedCostlist);
        parcel.writeInt(this.topSpeed);
        parcel.writeList(this.transCostlist);
        parcel.writeInt(this.vehicleWeight);
        if (getDataVersion() >= 1) {
            parcel.writeTypedList(this.powertrainLoss);
        }
    }

    public RspCarEnergyInfoModel(double d, int i, ArrayList<Double> arrayList, int i2, double d2, double d3, boolean z, int i3, int i4, double d4, double d5, ArrayList<PowertrainLossInfo> arrayList2, int i5, ArrayList<Double> arrayList3, ArrayList<Double> arrayList4, int i6, ArrayList<Double> arrayList5, int i7) {
        setProtocolID(80038);
        this.auxCost = d;
        this.curDriveMode = i;
        this.curveCostlist = arrayList;
        this.energyUnit = i2;
        this.ferryrateCost = d2;
        this.initialHvBattenergy = d3;
        this.isCharge = z;
        this.lowEnergyAlert = i3;
        this.lowEnergyWarn = i4;
        this.maxBattEnergy = d4;
        this.percentOfResidualEnergy = d5;
        this.powertrainLoss = arrayList2;
        this.rangeDist = i5;
        this.slopeCostlist = arrayList3;
        this.speedCostlist = arrayList4;
        this.topSpeed = i6;
        this.transCostlist = arrayList5;
        this.vehicleWeight = i7;
    }

    public RspCarEnergyInfoModel(Parcel parcel) {
        super(parcel);
        this.auxCost = parcel.readDouble();
        this.curDriveMode = parcel.readInt();
        this.curveCostlist = parcel.readArrayList(Double.class.getClassLoader());
        this.energyUnit = parcel.readInt();
        this.ferryrateCost = parcel.readDouble();
        this.initialHvBattenergy = parcel.readDouble();
        this.isCharge = parcel.readByte() != 0;
        this.lowEnergyAlert = parcel.readInt();
        this.lowEnergyWarn = parcel.readInt();
        this.maxBattEnergy = parcel.readDouble();
        this.percentOfResidualEnergy = parcel.readDouble();
        this.rangeDist = parcel.readInt();
        this.slopeCostlist = parcel.readArrayList(Double.class.getClassLoader());
        this.speedCostlist = parcel.readArrayList(Double.class.getClassLoader());
        this.topSpeed = parcel.readInt();
        this.transCostlist = parcel.readArrayList(Double.class.getClassLoader());
        this.vehicleWeight = parcel.readInt();
        if (getDataVersion() >= 1) {
            this.powertrainLoss = parcel.createTypedArrayList(PowertrainLossInfo.CREATOR);
        }
    }
}
