package com.autonavi.amapauto.protocol.model.client;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.item.PowertrainLossInfo;
import com.autonavi.amapauto.protocol.model.item.PowertrainLossInfo_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspCarEnergyInfoModel_JsonLubeParser implements Serializable {
    public static RspCarEnergyInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RspCarEnergyInfoModel rspCarEnergyInfoModel = new RspCarEnergyInfoModel();
        rspCarEnergyInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", rspCarEnergyInfoModel.getClientPackageName()));
        rspCarEnergyInfoModel.setPackageName(jSONObject.optString("packageName", rspCarEnergyInfoModel.getPackageName()));
        rspCarEnergyInfoModel.setCallbackId(jSONObject.optInt("callbackId", rspCarEnergyInfoModel.getCallbackId()));
        rspCarEnergyInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", rspCarEnergyInfoModel.getTimeStamp()));
        rspCarEnergyInfoModel.setVar1(jSONObject.optString("var1", rspCarEnergyInfoModel.getVar1()));
        rspCarEnergyInfoModel.setAuxCost(jSONObject.optDouble("auxCost", rspCarEnergyInfoModel.getAuxCost()));
        rspCarEnergyInfoModel.setCurDriveMode(jSONObject.optInt("curDriveMode", rspCarEnergyInfoModel.getCurDriveMode()));
        JSONArray optJSONArray = jSONObject.optJSONArray("curveCostlist");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<Double> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(Double.valueOf(optJSONArray.optDouble(i)));
            }
            rspCarEnergyInfoModel.setCurveCostlist(arrayList);
        }
        rspCarEnergyInfoModel.setEnergyUnit(jSONObject.optInt("energyUnit", rspCarEnergyInfoModel.getEnergyUnit()));
        rspCarEnergyInfoModel.setFerryrateCost(jSONObject.optDouble("ferryrateCost", rspCarEnergyInfoModel.getFerryrateCost()));
        rspCarEnergyInfoModel.setInitialHvBattenergy(jSONObject.optDouble("initialHvBattenergy", rspCarEnergyInfoModel.getInitialHvBattenergy()));
        rspCarEnergyInfoModel.setIsCharge(jSONObject.optBoolean("isCharge", rspCarEnergyInfoModel.getIsCharge()));
        rspCarEnergyInfoModel.setLowEnergyAlert(jSONObject.optInt("lowEnergyAlert", rspCarEnergyInfoModel.getLowEnergyAlert()));
        rspCarEnergyInfoModel.setLowEnergyWarn(jSONObject.optInt("lowEnergyWarn", rspCarEnergyInfoModel.getLowEnergyWarn()));
        rspCarEnergyInfoModel.setMaxBattEnergy(jSONObject.optDouble("maxBattEnergy", rspCarEnergyInfoModel.getMaxBattEnergy()));
        rspCarEnergyInfoModel.setPercentOfResidualEnergy(jSONObject.optDouble(StandardProtocolKey.EXTRA_PERCENT_OF_RESIDUAL_ENERGY, rspCarEnergyInfoModel.getPercentOfResidualEnergy()));
        JSONArray optJSONArray2 = jSONObject.optJSONArray("powertrainLoss");
        if (optJSONArray2 != null) {
            int length2 = optJSONArray2.length();
            ArrayList<PowertrainLossInfo> arrayList2 = new ArrayList<>(length2);
            for (int i2 = 0; i2 < length2; i2++) {
                arrayList2.add(PowertrainLossInfo_JsonLubeParser.parse(optJSONArray2.optJSONObject(i2)));
            }
            rspCarEnergyInfoModel.setPowertrainLoss(arrayList2);
        }
        rspCarEnergyInfoModel.setRangeDist(jSONObject.optInt("rangeDist", rspCarEnergyInfoModel.getRangeDist()));
        JSONArray optJSONArray3 = jSONObject.optJSONArray("slopeCostlist");
        if (optJSONArray3 != null) {
            int length3 = optJSONArray3.length();
            ArrayList<Double> arrayList3 = new ArrayList<>(length3);
            for (int i3 = 0; i3 < length3; i3++) {
                arrayList3.add(Double.valueOf(optJSONArray3.optDouble(i3)));
            }
            rspCarEnergyInfoModel.setSlopeCostlist(arrayList3);
        }
        JSONArray optJSONArray4 = jSONObject.optJSONArray("speedCostlist");
        if (optJSONArray4 != null) {
            int length4 = optJSONArray4.length();
            ArrayList<Double> arrayList4 = new ArrayList<>(length4);
            for (int i4 = 0; i4 < length4; i4++) {
                arrayList4.add(Double.valueOf(optJSONArray4.optDouble(i4)));
            }
            rspCarEnergyInfoModel.setSpeedCostlist(arrayList4);
        }
        rspCarEnergyInfoModel.setTopSpeed(jSONObject.optInt("topSpeed", rspCarEnergyInfoModel.getTopSpeed()));
        JSONArray optJSONArray5 = jSONObject.optJSONArray("transCostlist");
        if (optJSONArray5 != null) {
            int length5 = optJSONArray5.length();
            ArrayList<Double> arrayList5 = new ArrayList<>(length5);
            for (int i5 = 0; i5 < length5; i5++) {
                arrayList5.add(Double.valueOf(optJSONArray5.optDouble(i5)));
            }
            rspCarEnergyInfoModel.setTransCostlist(arrayList5);
        }
        rspCarEnergyInfoModel.setVehicleWeight(jSONObject.optInt("vehicleWeight", rspCarEnergyInfoModel.getVehicleWeight()));
        return rspCarEnergyInfoModel;
    }
}
